/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLColumnType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementParameterType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComParsePacket
extends PostgreSQLCommandPacket {
    private final String statementId;
    private final String sql;
    private final List<PostgreSQLBinaryStatementParameterType> binaryStatementParameterTypes;

    public PostgreSQLComParsePacket(PostgreSQLPacketPayload payload) {
        payload.readInt4();
        this.statementId = payload.readStringNul();
        this.sql = this.alterSQLToJDBCStyle(payload.readStringNul());
        this.binaryStatementParameterTypes = this.sql.isEmpty() ? Collections.emptyList() : this.getParameterTypes(payload);
    }

    private List<PostgreSQLBinaryStatementParameterType> getParameterTypes(PostgreSQLPacketPayload payload) {
        int parametersCount = payload.readInt2();
        ArrayList<PostgreSQLBinaryStatementParameterType> result = new ArrayList<PostgreSQLBinaryStatementParameterType>(parametersCount);
        for (int i = 0; i < parametersCount; ++i) {
            result.add(new PostgreSQLBinaryStatementParameterType(PostgreSQLColumnType.valueOf(payload.readInt4())));
        }
        return result;
    }

    private String alterSQLToJDBCStyle(String sql) {
        return sql.replaceAll("\\$[0-9]+", "?");
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public char getMessageType() {
        return PostgreSQLCommandPacketType.PARSE.getValue();
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<PostgreSQLBinaryStatementParameterType> getBinaryStatementParameterTypes() {
        return this.binaryStatementParameterTypes;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComParsePacket(statementId=" + this.getStatementId() + ", sql=" + this.getSql() + ", binaryStatementParameterTypes=" + this.getBinaryStatementParameterTypes() + ")";
    }
}

