/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.admin.PostgreSQLUnsupportedCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.sync.PostgreSQLComSyncPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.text.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.generic.PostgreSQLComTerminationPacket;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLCommandPacketFactory {
    public static PostgreSQLCommandPacket newInstance(PostgreSQLCommandPacketType commandPacketType, PostgreSQLPacketPayload payload, int connectionId) throws SQLException {
        switch (commandPacketType) {
            case QUERY: {
                return new PostgreSQLComQueryPacket(payload);
            }
            case PARSE: {
                return new PostgreSQLComParsePacket(payload);
            }
            case BIND: {
                return new PostgreSQLComBindPacket(payload, connectionId);
            }
            case DESCRIBE: {
                return new PostgreSQLComDescribePacket(payload);
            }
            case EXECUTE: {
                return new PostgreSQLComExecutePacket(payload);
            }
            case SYNC: {
                return new PostgreSQLComSyncPacket(payload);
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationPacket(payload);
            }
        }
        return new PostgreSQLUnsupportedCommandPacket(commandPacketType.getValue());
    }

    @Generated
    private PostgreSQLCommandPacketFactory() {
    }
}

