/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.text;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLDataRowPacket
implements PostgreSQLPacket {
    private final char messageType = PostgreSQLCommandPacketType.DATA_ROW.getValue();
    private final List<Object> data;

    public void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.data.size());
        for (Object each : this.data) {
            if (null == each) {
                payload.writeInt4(-1);
                continue;
            }
            if (each instanceof byte[]) {
                payload.writeInt4(((byte[])each).length);
                payload.writeBytes((byte[])each);
                continue;
            }
            String columnData = each.toString();
            payload.writeInt4(columnData.getBytes().length);
            payload.writeStringEOF(columnData);
        }
    }

    @Generated
    public PostgreSQLDataRowPacket(List<Object> data) {
        this.data = data;
    }

    @Override
    @Generated
    public char getMessageType() {
        return this.messageType;
    }

    @Generated
    public List<Object> getData() {
        return this.data;
    }
}

