/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLColumnType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLDateBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLDoubleBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLFloatBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLInt2BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLInt4BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLInt8BinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLStringBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLTimeBinaryProtocolValue;

public final class PostgreSQLBinaryProtocolValueFactory {
    private static final Map<PostgreSQLColumnType, PostgreSQLBinaryProtocolValue> BINARY_PROTOCOL_VALUES = new HashMap<PostgreSQLColumnType, PostgreSQLBinaryProtocolValue>();

    private static void setStringLenencBinaryProtocolValue() {
        PostgreSQLStringBinaryProtocolValue binaryProtocolValue = new PostgreSQLStringBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_VARCHAR, binaryProtocolValue);
    }

    private static void setInt8BinaryProtocolValue() {
        PostgreSQLInt8BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt8BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT8, binaryProtocolValue);
    }

    private static void setInt4BinaryProtocolValue() {
        PostgreSQLInt4BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt4BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT4, binaryProtocolValue);
    }

    private static void setInt2BinaryProtocolValue() {
        PostgreSQLInt2BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt2BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT2, binaryProtocolValue);
    }

    private static void setDoubleBinaryProtocolValue() {
        PostgreSQLDoubleBinaryProtocolValue binaryProtocolValue = new PostgreSQLDoubleBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT8, binaryProtocolValue);
    }

    private static void setFloatBinaryProtocolValue() {
        PostgreSQLFloatBinaryProtocolValue binaryProtocolValue = new PostgreSQLFloatBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT4, binaryProtocolValue);
    }

    private static void setDateBinaryProtocolValue() {
        PostgreSQLDateBinaryProtocolValue binaryProtocolValue = new PostgreSQLDateBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_DATE, binaryProtocolValue);
    }

    private static void setTimeBinaryProtocolValue() {
        PostgreSQLTimeBinaryProtocolValue binaryProtocolValue = new PostgreSQLTimeBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_TIMESTAMP, binaryProtocolValue);
    }

    public static PostgreSQLBinaryProtocolValue getBinaryProtocolValue(PostgreSQLColumnType columnType) {
        Preconditions.checkArgument((boolean)BINARY_PROTOCOL_VALUES.containsKey((Object)columnType), (String)"Cannot find PostgreSQL type '%s' in column type when process binary protocol value", (Object[])new Object[]{columnType});
        return BINARY_PROTOCOL_VALUES.get((Object)columnType);
    }

    @Generated
    private PostgreSQLBinaryProtocolValueFactory() {
    }

    static {
        PostgreSQLBinaryProtocolValueFactory.setStringLenencBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt8BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt4BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt2BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setDoubleBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setFloatBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setDateBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setTimeBinaryProtocolValue();
    }
}

