/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.BinaryStatementRegistry;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementParameterType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComBindPacket
extends PostgreSQLCommandPacket {
    private final String statementId;
    private final String sql;
    private final List<Object> parameters;
    private final boolean binaryRowData;

    public PostgreSQLComBindPacket(PostgreSQLPacketPayload payload, int connectionId) throws SQLException {
        payload.readInt4();
        payload.readStringNul();
        this.statementId = payload.readStringNul();
        int parameterFormatsLength = payload.readInt2();
        for (int i = 0; i < parameterFormatsLength; ++i) {
            payload.readInt2();
        }
        PostgreSQLBinaryStatement binaryStatement = BinaryStatementRegistry.getInstance().get(connectionId).getBinaryStatement(this.statementId);
        this.sql = null == binaryStatement ? null : binaryStatement.getSql();
        this.parameters = null == this.sql ? Collections.emptyList() : this.getParameters(payload, binaryStatement.getParameterTypes());
        int resultFormatsLength = payload.readInt2();
        this.binaryRowData = resultFormatsLength > 0;
        for (int i = 0; i < resultFormatsLength; ++i) {
            payload.readInt2();
        }
    }

    private List<Object> getParameters(PostgreSQLPacketPayload payload, List<PostgreSQLBinaryStatementParameterType> parameterTypes) throws SQLException {
        int parametersCount = payload.readInt2();
        ArrayList<Object> result = new ArrayList<Object>(parametersCount);
        for (int parameterIndex = 0; parameterIndex < parametersCount; ++parameterIndex) {
            payload.readInt4();
            PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(parameterTypes.get(parameterIndex).getColumnType());
            result.add(binaryProtocolValue.read(payload));
        }
        return result;
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public char getMessageType() {
        return PostgreSQLCommandPacketType.BIND.getValue();
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean isBinaryRowData() {
        return this.binaryRowData;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComBindPacket(statementId=" + this.getStatementId() + ", sql=" + this.getSql() + ", parameters=" + this.getParameters() + ", binaryRowData=" + this.isBinaryRowData() + ")";
    }
}

