/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLSSLNegativePacket;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLPacketCodecEngine
implements DatabasePacketCodecEngine<PostgreSQLPacket> {
    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= 5;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out, int readableBytes) {
        int messageTypeLength = 0;
        if (0 == in.markReaderIndex().readByte()) {
            in.resetReaderIndex();
        } else {
            messageTypeLength = 1;
        }
        int payloadLength = in.readInt();
        int realPacketLength = payloadLength + messageTypeLength;
        if (readableBytes < realPacketLength) {
            in.resetReaderIndex();
            return;
        }
        in.resetReaderIndex();
        out.add(in.readRetainedSlice(payloadLength + messageTypeLength));
    }

    public void encode(ChannelHandlerContext context, PostgreSQLPacket message, ByteBuf out) {
        try (PostgreSQLPacketPayload payload = new PostgreSQLPacketPayload(context.alloc().buffer());){
            message.write(payload);
            if (!(message instanceof PostgreSQLSSLNegativePacket)) {
                out.writeByte((int)message.getMessageType());
                out.writeInt(payload.getByteBuf().readableBytes() + 4);
            }
            out.writeBytes(payload.getByteBuf());
        }
    }

    public PostgreSQLPacketPayload createPacketPayload(ByteBuf message) {
        return new PostgreSQLPacketPayload(message);
    }
}

