/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.datetime.database.spi;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.datetime.database.exception.NoDatabaseSQLEntrySupportException;
import org.apache.shardingsphere.datetime.database.spi.DatabaseSQLEntry;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class SPIDataBaseSQLEntry
implements DatabaseSQLEntry {
    private final Collection<DatabaseSQLEntry> sqlEntries = ShardingSphereServiceLoader.getSingletonServiceInstances(DatabaseSQLEntry.class);
    private final String driverClassName;

    @Override
    public String getSQL() {
        for (DatabaseSQLEntry each : this.sqlEntries) {
            if (!each.isSupport(this.driverClassName)) continue;
            return each.getSQL();
        }
        throw new NoDatabaseSQLEntrySupportException();
    }

    @Override
    public boolean isSupport(String driverClassName) {
        return true;
    }

    @Generated
    public SPIDataBaseSQLEntry(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseSQLEntry.class);
    }
}

