/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.postgresql.PGConnection;
import org.postgresql.PGProperty;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;

public final class PostgreSQLLogicalReplication {
    public Connection createConnection(StandardPipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, pipelineDataSourceConfig.getUsername());
        PGProperty.PASSWORD.set(props, pipelineDataSourceConfig.getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.6");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        return DriverManager.getConnection(pipelineDataSourceConfig.getUrl(), props);
    }

    public PGReplicationStream createReplicationStream(Connection connection, String slotName, BaseLogSequenceNumber startPosition) throws SQLException {
        return ((ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)connection.unwrap(PGConnection.class).getReplicationAPI().replicationStream().logical().withStartPosition((LogSequenceNumber)startPosition.get())).withSlotName(slotName)).withSlotOption("include-xids", true).withSlotOption("skip-empty-xacts", true).start();
    }
}

