/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ddlgenerator;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.postgresql.util.PostgreSQLPipelineFreemarkerManager;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;

public abstract class AbstractPostgreSQLDDLAdapter {
    private static final String SECURITY_LABEL_SPLIT = "=";
    private final Connection connection;
    private final int majorVersion;
    private final int minorVersion;

    /*
     * Enabled aggressive exception aggregation
     */
    protected Collection<Map<String, Object>> executeByTemplate(Map<String, Object> params, String path) {
        try (Statement statement = this.connection.createStatement();){
            Collection<Map<String, Object>> collection;
            block14: {
                ResultSet resultSet = statement.executeQuery(PostgreSQLPipelineFreemarkerManager.getSQLByVersion(params, path, this.majorVersion, this.minorVersion));
                try {
                    collection = this.getRows(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return collection;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    private Collection<Map<String, Object>> getRows(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        while (resultSet.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                row.put(metaData.getColumnName(i), resultSet.getObject(i));
            }
            result.add(row);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> executeByTemplateForSingleRow(Map<String, Object> params, String path) {
        try (Statement statement = this.connection.createStatement();){
            Map<String, Object> map;
            block14: {
                ResultSet resultSet = statement.executeQuery(PostgreSQLPipelineFreemarkerManager.getSQLByVersion(params, path, this.majorVersion, this.minorVersion));
                try {
                    map = this.getSingleRow(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return map;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    private Map<String, Object> getSingleRow(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (resultSet.next()) {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                result.put(metaData.getColumnName(i), resultSet.getObject(i));
            }
        }
        return result;
    }

    protected void formatSecurityLabels(Map<String, Object> data) throws SQLException {
        if (null == data.get("seclabels")) {
            return;
        }
        LinkedList formatLabels = new LinkedList();
        Collection securityLabels = Arrays.stream((String[])((Array)data.get("seclabels")).getArray()).collect(Collectors.toList());
        for (String each : securityLabels) {
            LinkedHashMap<String, String> securityLabel = new LinkedHashMap<String, String>();
            securityLabel.put("provider", each.substring(0, each.indexOf(SECURITY_LABEL_SPLIT)));
            securityLabel.put("label", each.substring(each.indexOf(SECURITY_LABEL_SPLIT) + 1));
            formatLabels.add(securityLabel);
        }
        data.put("seclabels", formatLabels);
    }

    @Generated
    protected AbstractPostgreSQLDDLAdapter(Connection connection, int majorVersion, int minorVersion) {
        this.connection = connection;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }

    @Generated
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Generated
    public int getMinorVersion() {
        return this.minorVersion;
    }
}

