/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.check.datasource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.checker.DialectDataSourceChecker;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithCheckPrivilegeFailedException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithoutEnoughPrivilegeException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithoutUserException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLDataSourceChecker
implements DialectDataSourceChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLDataSourceChecker.class);
    private static final String SHOW_GRANTS_SQL = "SELECT * FROM pg_roles WHERE rolname = ?";

    public void checkPrivilege(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);){
            DatabaseMetaData metaData = connection.getMetaData();
            preparedStatement.setString(1, metaData.getUserName());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                String username = metaData.getUserName();
                ShardingSpherePreconditions.checkState((boolean)resultSet.next(), () -> new PrepareJobWithoutUserException(username));
                String isSuperRole = resultSet.getString("rolsuper");
                String isReplicationRole = resultSet.getString("rolreplication");
                log.info("checkPrivilege: isSuperRole: {}, isReplicationRole: {}", (Object)isSuperRole, (Object)isReplicationRole);
                ShardingSpherePreconditions.checkState(("t".equalsIgnoreCase(isSuperRole) || "t".equalsIgnoreCase(isReplicationRole) ? 1 : 0) != 0, () -> new PrepareJobWithoutEnoughPrivilegeException(Collections.singleton("REPLICATION")));
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithCheckPrivilegeFailedException(ex);
        }
    }

    public void checkVariable(DataSource dataSource) {
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

