/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.column.value.impl;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.column.value.MySQLDataTypeHandler;

public final class MySQLUnsignedBigintHandler
implements MySQLDataTypeHandler {
    private static final BigInteger BIGINT_MODULO = new BigInteger("18446744073709551616");

    @Override
    public Serializable handle(Serializable value) {
        if (null == value) {
            return null;
        }
        long longValue = (Long)value;
        return 0L > longValue ? BIGINT_MODULO.add(BigInteger.valueOf(longValue)) : Long.valueOf(longValue);
    }

    public String getType() {
        return "BIGINT UNSIGNED";
    }
}

