/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthMoreDataPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchRequestPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakePacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class MySQLNegotiatePackageDecoder
extends ByteToMessageDecoder {
    private volatile boolean handshakeReceived;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        if (this.handshakeReceived) {
            MySQLPacket responsePacket = this.decodeResponsePacket(payload);
            if (responsePacket instanceof MySQLOKPacket) {
                ctx.channel().pipeline().remove((ChannelHandler)this);
            }
            out.add(responsePacket);
        } else {
            out.add(this.decodeHandshakePacket(payload));
            this.handshakeReceived = true;
        }
    }

    private MySQLHandshakePacket decodeHandshakePacket(MySQLPacketPayload payload) {
        return new MySQLHandshakePacket(payload);
    }

    private MySQLPacket decodeResponsePacket(MySQLPacketPayload payload) {
        int header = payload.getByteBuf().getByte(0) & 0xFF;
        switch (header) {
            case 255: {
                return new MySQLErrPacket(payload);
            }
            case 0: {
                return new MySQLOKPacket(payload);
            }
            case 254: {
                return new MySQLAuthSwitchRequestPacket(payload);
            }
            case 1: {
                return new MySQLAuthMoreDataPacket(payload);
            }
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported negotiate response header: %X", header));
    }
}

