/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import java.security.NoSuchAlgorithmException;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.PasswordEncryption;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ServerInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ServerVersion;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLAuthenticationPlugin;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthMoreDataPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchRequestPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchResponsePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakeResponse41Packet;

public final class MySQLNegotiateHandler
extends ChannelInboundHandlerAdapter {
    private static final int MAX_PACKET_SIZE = 0x1000000;
    private static final int CHARACTER_SET = 33;
    private static final int REQUEST_PUBLIC_KEY = 2;
    private static final int PERFORM_FULL_AUTHENTICATION = 4;
    private final String username;
    private final String password;
    private final Promise<Object> authResultCallback;
    private ServerInfo serverInfo;
    private byte[] seed;
    private boolean publicKeyRequested;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof MySQLHandshakePacket) {
            MySQLHandshakePacket handshake = (MySQLHandshakePacket)msg;
            MySQLHandshakeResponse41Packet handshakeResponsePacket = new MySQLHandshakeResponse41Packet(0x1000000, 33, this.username);
            handshakeResponsePacket.setAuthResponse(this.generateAuthResponse(handshake.getAuthPluginData().getAuthenticationPluginData()));
            handshakeResponsePacket.setCapabilityFlags(this.generateClientCapability());
            handshakeResponsePacket.setAuthPluginName(MySQLAuthenticationMethod.NATIVE);
            ctx.channel().writeAndFlush((Object)handshakeResponsePacket);
            this.serverInfo = new ServerInfo(new ServerVersion(handshake.getServerVersion()));
            return;
        }
        if (msg instanceof MySQLAuthSwitchRequestPacket) {
            MySQLAuthSwitchRequestPacket authSwitchRequest = (MySQLAuthSwitchRequestPacket)msg;
            ctx.channel().writeAndFlush((Object)new MySQLAuthSwitchResponsePacket(this.getAuthPluginResponse(authSwitchRequest)));
            this.seed = authSwitchRequest.getAuthPluginData().getAuthenticationPluginData();
            return;
        }
        if (msg instanceof MySQLAuthMoreDataPacket) {
            MySQLAuthMoreDataPacket authMoreData = (MySQLAuthMoreDataPacket)msg;
            this.handleCachingSha2Auth(ctx, authMoreData);
            return;
        }
        if (msg instanceof MySQLOKPacket) {
            ctx.channel().pipeline().remove((ChannelHandler)this);
            this.authResultCallback.setSuccess((Object)this.serverInfo);
            return;
        }
        MySQLErrPacket error = (MySQLErrPacket)msg;
        ctx.channel().close();
        throw new PipelineInternalException(error.getErrorMessage(), new Object[0]);
    }

    private byte[] getAuthPluginResponse(MySQLAuthSwitchRequestPacket authSwitchRequest) throws NoSuchAlgorithmException {
        switch (MySQLAuthenticationPlugin.getPluginByName((String)authSwitchRequest.getAuthPluginName())) {
            case NATIVE: {
                return PasswordEncryption.encryptWithMySQL41(this.password.getBytes(), authSwitchRequest.getAuthPluginData().getAuthenticationPluginData());
            }
            case CACHING_SHA2: {
                return PasswordEncryption.encryptWithSha2(this.password.getBytes(), authSwitchRequest.getAuthPluginData().getAuthenticationPluginData());
            }
        }
        return this.password.getBytes();
    }

    private void handleCachingSha2Auth(ChannelHandlerContext ctx, MySQLAuthMoreDataPacket authMoreData) {
        if (this.publicKeyRequested) {
            ctx.channel().writeAndFlush((Object)new MySQLAuthSwitchResponsePacket(PasswordEncryption.encryptWithRSAPublicKey(this.password, this.seed, this.serverInfo.getServerVersion().greaterThanOrEqualTo(8, 0, 5) ? "RSA/ECB/OAEPWithSHA-1AndMGF1Padding" : "RSA/ECB/PKCS1Padding", new String(authMoreData.getPluginData()))));
        } else if (4 == authMoreData.getPluginData()[0]) {
            this.publicKeyRequested = true;
            ctx.channel().writeAndFlush((Object)new MySQLAuthSwitchResponsePacket(new byte[]{2}));
        }
    }

    private int generateClientCapability() {
        return MySQLCapabilityFlag.calculateCapabilityFlags((MySQLCapabilityFlag[])new MySQLCapabilityFlag[]{MySQLCapabilityFlag.CLIENT_LONG_PASSWORD, MySQLCapabilityFlag.CLIENT_LONG_FLAG, MySQLCapabilityFlag.CLIENT_PROTOCOL_41, MySQLCapabilityFlag.CLIENT_INTERACTIVE, MySQLCapabilityFlag.CLIENT_TRANSACTIONS, MySQLCapabilityFlag.CLIENT_SECURE_CONNECTION, MySQLCapabilityFlag.CLIENT_MULTI_STATEMENTS, MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH});
    }

    private byte[] generateAuthResponse(byte[] authPluginData) {
        return null == this.password || this.password.isEmpty() ? new byte[]{} : PasswordEncryption.encryptWithMySQL41(this.password.getBytes(), authPluginData);
    }

    @Generated
    public MySQLNegotiateHandler(String username, String password, Promise<Object> authResultCallback) {
        this.username = username;
        this.password = password;
        this.authResultCallback = authResultCallback;
    }
}

