/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.InternalResultSet;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLFieldCountPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLCommandPacketDecoder
extends ByteToMessageDecoder {
    private final AtomicReference<States> currentState = new AtomicReference<States>(States.RESPONSE_PACKET);
    private final AtomicReference<InternalResultSet> internalResultSet = new AtomicReference();

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        this.decodeCommandPacket(payload, out);
    }

    private void decodeCommandPacket(MySQLPacketPayload payload, List<Object> out) {
        if (States.FIELD_PACKET == this.currentState.get()) {
            this.decodeFieldPacket(payload);
            return;
        }
        if (States.ROW_DATA_PACKET == this.currentState.get()) {
            this.decodeRowDataPacket(payload, out);
            return;
        }
        this.decodeResponsePacket(payload, out);
    }

    private void decodeFieldPacket(MySQLPacketPayload payload) {
        if (254 == (payload.getByteBuf().getByte(0) & 0xFF)) {
            new MySQLEofPacket(payload);
            this.currentState.set(States.ROW_DATA_PACKET);
        } else {
            this.internalResultSet.get().getFieldDescriptors().add(new MySQLColumnDefinition41Packet(payload));
        }
    }

    private void decodeRowDataPacket(MySQLPacketPayload payload, List<Object> out) {
        if (254 == (payload.getByteBuf().getByte(0) & 0xFF)) {
            new MySQLEofPacket(payload);
            out.add(this.internalResultSet.get());
            this.currentState.set(States.RESPONSE_PACKET);
            this.internalResultSet.set(null);
        } else {
            this.internalResultSet.get().getFieldValues().add(new MySQLTextResultSetRowPacket(payload, this.internalResultSet.get().getHeader().getColumnCount()));
        }
    }

    private void decodeResponsePacket(MySQLPacketPayload payload, List<Object> out) {
        switch (payload.getByteBuf().getByte(0) & 0xFF) {
            case 255: {
                out.add(new MySQLErrPacket(payload));
                break;
            }
            case 0: {
                out.add(new MySQLOKPacket(payload));
                break;
            }
            default: {
                MySQLFieldCountPacket fieldCountPacket = new MySQLFieldCountPacket(payload);
                this.currentState.set(States.FIELD_PACKET);
                this.internalResultSet.set(new InternalResultSet(fieldCountPacket));
            }
        }
    }

    private static enum States {
        RESPONSE_PACKET,
        FIELD_PACKET,
        ROW_DATA_PACKET;

    }
}

