/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.BinlogContext;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.DeleteRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.PlaceholderEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.QueryEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.UpdateRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.WriteRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.XidEvent;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinlogEventType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.management.MySQLBinlogFormatDescriptionEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.management.MySQLBinlogRotateEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogRowsEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogTableMapEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLBinlogEventPacketDecoder
extends ByteToMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLBinlogEventPacketDecoder.class);
    private static final String TX_BEGIN_SQL = "BEGIN";
    private final BinlogContext binlogContext;
    private final boolean decodeWithTX;
    private List<AbstractBinlogEvent> records = new LinkedList<AbstractBinlogEvent>();

    public MySQLBinlogEventPacketDecoder(int checksumLength, Map<Long, MySQLBinlogTableMapEventPacket> tableMap, boolean decodeWithTX) {
        this.decodeWithTX = decodeWithTX;
        this.binlogContext = new BinlogContext(checksumLength, tableMap);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        while (in.readableBytes() >= 20) {
            in.markReaderIndex();
            MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
            this.checkPayload(payload);
            MySQLBinlogEventHeader binlogEventHeader = new MySQLBinlogEventHeader(payload, this.binlogContext.getChecksumLength());
            if (!this.checkEventIntegrity(in, binlogEventHeader)) {
                return;
            }
            Optional<AbstractBinlogEvent> binlogEvent = this.decodeEvent(binlogEventHeader, payload);
            if (!binlogEvent.isPresent()) {
                this.skipChecksum(binlogEventHeader.getEventType(), in);
                return;
            }
            if (binlogEvent.get() instanceof PlaceholderEvent) {
                out.add(binlogEvent.get());
                this.skipChecksum(binlogEventHeader.getEventType(), in);
                return;
            }
            if (this.decodeWithTX) {
                this.processEventWithTX(binlogEvent.get(), out);
            } else {
                this.processEventIgnoreTX(binlogEvent.get(), out);
            }
            this.skipChecksum(binlogEventHeader.getEventType(), in);
        }
    }

    private void checkPayload(MySQLPacketPayload payload) {
        int statusCode = payload.readInt1();
        if (255 == statusCode) {
            int errorNo = payload.readInt2();
            payload.skipReserved(1);
            String sqlState = payload.readStringFix(5);
            throw new PipelineInternalException("Decode binlog event failed, errorCode: %d, sqlState: %s, errorMessage: %s", new Object[]{errorNo, sqlState, payload.readStringEOF()});
        }
        if (0 != statusCode) {
            log.debug("Illegal binlog status code {}, remaining packet \n{}", (Object)statusCode, (Object)this.readRemainPacket(payload));
        }
    }

    private String readRemainPacket(MySQLPacketPayload payload) {
        return ByteBufUtil.hexDump((byte[])payload.readStringFixByBytes(payload.getByteBuf().readableBytes()));
    }

    private boolean checkEventIntegrity(ByteBuf in, MySQLBinlogEventHeader binlogEventHeader) {
        if (in.readableBytes() < binlogEventHeader.getEventSize() - 19) {
            log.debug("the event body is not complete, event size={}, readable bytes={}", (Object)binlogEventHeader.getEventSize(), (Object)in.readableBytes());
            in.resetReaderIndex();
            return false;
        }
        return true;
    }

    private void processEventWithTX(AbstractBinlogEvent binlogEvent, List<Object> out) {
        if (binlogEvent instanceof QueryEvent) {
            QueryEvent queryEvent = (QueryEvent)binlogEvent;
            if (TX_BEGIN_SQL.equals(queryEvent.getSql())) {
                this.records = new LinkedList<AbstractBinlogEvent>();
            } else {
                out.add(binlogEvent);
            }
        } else if (binlogEvent instanceof XidEvent) {
            this.records.add(binlogEvent);
            out.add(this.records);
        } else {
            this.records.add(binlogEvent);
        }
    }

    private void processEventIgnoreTX(AbstractBinlogEvent binlogEvent, List<Object> out) {
        QueryEvent queryEvent;
        if (binlogEvent instanceof QueryEvent && TX_BEGIN_SQL.equals((queryEvent = (QueryEvent)binlogEvent).getSql())) {
            return;
        }
        out.add(binlogEvent);
    }

    private Optional<AbstractBinlogEvent> decodeEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        switch (MySQLBinlogEventType.valueOf((int)binlogEventHeader.getEventType()).orElse(MySQLBinlogEventType.UNKNOWN_EVENT)) {
            case ROTATE_EVENT: {
                this.decodeRotateEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case FORMAT_DESCRIPTION_EVENT: {
                this.decodeFormatDescriptionEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case TABLE_MAP_EVENT: {
                this.decodeTableMapEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case WRITE_ROWS_EVENT_V1: 
            case WRITE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeWriteRowsEventV2(binlogEventHeader, payload));
            }
            case UPDATE_ROWS_EVENT_V1: 
            case UPDATE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeUpdateRowsEventV2(binlogEventHeader, payload));
            }
            case DELETE_ROWS_EVENT_V1: 
            case DELETE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeDeleteRowsEventV2(binlogEventHeader, payload));
            }
            case QUERY_EVENT: {
                return Optional.of(this.decodeQueryEvent(binlogEventHeader, payload));
            }
            case XID_EVENT: {
                return Optional.of(this.decodeXidEvent(binlogEventHeader, payload));
            }
        }
        return Optional.of(this.decodePlaceholderEvent(binlogEventHeader, payload));
    }

    private void decodeRotateEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRotateEventPacket packet = new MySQLBinlogRotateEventPacket(binlogEventHeader, payload);
        this.binlogContext.setFileName(packet.getNextBinlogName());
    }

    private void decodeFormatDescriptionEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogFormatDescriptionEventPacket packet = new MySQLBinlogFormatDescriptionEventPacket(binlogEventHeader, payload);
        int readableBytes = payload.getByteBuf().readableBytes();
        if (binlogEventHeader.getChecksumLength() <= 0 && readableBytes > 0) {
            if (readableBytes != 4) {
                log.warn("the format description event has extra bytes, readable bytes length={}, binlogEventHeader={}, formatDescriptionEvent={}", new Object[]{readableBytes, binlogEventHeader, packet});
            }
            payload.getByteBuf().skipBytes(readableBytes);
        }
    }

    private void decodeTableMapEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogTableMapEventPacket packet = new MySQLBinlogTableMapEventPacket(binlogEventHeader, payload);
        this.binlogContext.putTableMapEvent(packet.getTableId(), packet);
    }

    private WriteRowsEvent decodeWriteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        packet.readRows(this.binlogContext.getTableMapEvent(packet.getTableId()), payload);
        WriteRowsEvent result = new WriteRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, packet.getTableId());
        result.setAfterRows(packet.getRows());
        return result;
    }

    private UpdateRowsEvent decodeUpdateRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        packet.readRows(this.binlogContext.getTableMapEvent(packet.getTableId()), payload);
        UpdateRowsEvent result = new UpdateRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, packet.getTableId());
        result.setBeforeRows(packet.getRows());
        result.setAfterRows(packet.getRows2());
        return result;
    }

    private DeleteRowsEvent decodeDeleteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        packet.readRows(this.binlogContext.getTableMapEvent(packet.getTableId()), payload);
        DeleteRowsEvent result = new DeleteRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, packet.getTableId());
        result.setBeforeRows(packet.getRows());
        return result;
    }

    private void initRowsEvent(AbstractRowsEvent rowsEvent, MySQLBinlogEventHeader binlogEventHeader, long tableId) {
        rowsEvent.setDatabaseName(this.binlogContext.getDatabaseName(tableId));
        rowsEvent.setTableName(this.binlogContext.getTableName(tableId));
        rowsEvent.setFileName(this.binlogContext.getFileName());
        rowsEvent.setPosition(binlogEventHeader.getLogPos());
        rowsEvent.setTimestamp(binlogEventHeader.getTimestamp());
        rowsEvent.setServerId(binlogEventHeader.getServerId());
    }

    private PlaceholderEvent decodePlaceholderEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        PlaceholderEvent result = this.createPlaceholderEvent(binlogEventHeader);
        int remainDataLength = binlogEventHeader.getEventSize() + 1 - binlogEventHeader.getChecksumLength() - payload.getByteBuf().readerIndex();
        if (remainDataLength > 0) {
            payload.skipReserved(remainDataLength);
        }
        return result;
    }

    private QueryEvent decodeQueryEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        int threadId = payload.readInt4();
        int executionTime = payload.readInt4();
        payload.skipReserved(1);
        int errorCode = payload.readInt2();
        payload.skipReserved(payload.readInt2());
        String databaseName = payload.readStringNul();
        String sql = payload.readStringFix(payload.getByteBuf().readableBytes() - binlogEventHeader.getChecksumLength());
        QueryEvent result = new QueryEvent(threadId, executionTime, errorCode, databaseName, sql);
        result.setFileName(this.binlogContext.getFileName());
        result.setPosition(binlogEventHeader.getLogPos());
        result.setTimestamp(binlogEventHeader.getTimestamp());
        result.setServerId(binlogEventHeader.getServerId());
        return result;
    }

    private XidEvent decodeXidEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        XidEvent result = new XidEvent(payload.readInt8());
        result.setFileName(this.binlogContext.getFileName());
        result.setPosition(binlogEventHeader.getLogPos());
        result.setTimestamp(binlogEventHeader.getTimestamp());
        result.setServerId(binlogEventHeader.getServerId());
        return result;
    }

    private PlaceholderEvent createPlaceholderEvent(MySQLBinlogEventHeader binlogEventHeader) {
        PlaceholderEvent result = new PlaceholderEvent();
        result.setFileName(this.binlogContext.getFileName());
        result.setPosition(binlogEventHeader.getLogPos());
        result.setTimestamp(binlogEventHeader.getTimestamp());
        return result;
    }

    private void skipChecksum(int eventType, ByteBuf in) {
        if (0 < this.binlogContext.getChecksumLength() && MySQLBinlogEventType.FORMAT_DESCRIPTION_EVENT.getValue() != eventType) {
            in.skipBytes(this.binlogContext.getChecksumLength());
        }
    }
}

