/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogTableMapEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;

public final class BinlogContext {
    private volatile String fileName;
    private final int checksumLength;
    private final Map<Long, MySQLBinlogTableMapEventPacket> tableMap;

    public void putTableMapEvent(long tableId, MySQLBinlogTableMapEventPacket tableMapEventPacket) {
        this.tableMap.put(tableId, tableMapEventPacket);
    }

    public MySQLBinlogTableMapEventPacket getTableMapEvent(long tableId) {
        return this.tableMap.get(tableId);
    }

    public String getTableName(long tableId) {
        return this.tableMap.get(tableId).getTableName();
    }

    public String getDatabaseName(long tableId) {
        return this.tableMap.get(tableId).getSchemaName();
    }

    public List<MySQLBinlogColumnDef> getColumnDefs(long tableId) {
        return this.tableMap.get(tableId).getColumnDefs();
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public int getChecksumLength() {
        return this.checksumLength;
    }

    @Generated
    public Map<Long, MySQLBinlogTableMapEventPacket> getTableMap() {
        return this.tableMap;
    }

    @Generated
    public BinlogContext(int checksumLength, Map<Long, MySQLBinlogTableMapEventPacket> tableMap) {
        this.checksumLength = checksumLength;
        this.tableMap = tableMap;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

