/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIngestPositionManager;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.BinlogPosition;

public final class MySQLIngestPositionManager
implements DialectIngestPositionManager {
    public BinlogPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            BinlogPosition binlogPosition = this.getBinlogPosition(connection);
            return binlogPosition;
        }
    }

    public BinlogPosition init(String data) {
        String[] array = data.split("#");
        Preconditions.checkArgument((2 == array.length ? 1 : 0) != 0, (String)"Unknown binlog position: %s", (Object)data);
        return new BinlogPosition(array[0], Long.parseLong(array[1]), 0L);
    }

    private BinlogPosition getBinlogPosition(Connection connection) throws SQLException {
        long serverId;
        long position;
        String filename;
        ResultSet resultSet;
        try (PreparedStatement preparedStatement = connection.prepareStatement("SHOW MASTER STATUS");){
            resultSet = preparedStatement.executeQuery();
            try {
                resultSet.next();
                filename = resultSet.getString(1);
                position = resultSet.getLong(2);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        preparedStatement = connection.prepareStatement("SHOW VARIABLES LIKE 'server_id'");
        try {
            resultSet = preparedStatement.executeQuery();
            try {
                resultSet.next();
                serverId = resultSet.getLong(2);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return new BinlogPosition(filename, position, serverId);
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

