/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.PlaceholderRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.BinlogPosition;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.DeleteRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.UpdateRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.WriteRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ConnectInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.MySQLClient;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.column.value.MySQLDataTypeHandler;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string.MySQLBinaryString;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLIncrementalDumper
extends AbstractPipelineLifecycleRunnable
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLIncrementalDumper.class);
    private final IncrementalDumperContext dumperContext;
    private final BinlogPosition binlogPosition;
    private final PipelineTableMetaDataLoader metaDataLoader;
    private final PipelineChannel channel;
    private final MySQLClient client;
    private final String catalog;

    public MySQLIncrementalDumper(IncrementalDumperContext dumperContext, IngestPosition binlogPosition, PipelineChannel channel, PipelineTableMetaDataLoader metaDataLoader) {
        Preconditions.checkArgument((boolean)(dumperContext.getCommonContext().getDataSourceConfig() instanceof StandardPipelineDataSourceConfiguration), (Object)"MySQLBinlogDumper only support StandardPipelineDataSourceConfiguration");
        this.dumperContext = dumperContext;
        this.binlogPosition = (BinlogPosition)binlogPosition;
        this.channel = channel;
        this.metaDataLoader = metaDataLoader;
        StandardPipelineDataSourceConfiguration pipelineDataSourceConfig = (StandardPipelineDataSourceConfiguration)dumperContext.getCommonContext().getDataSourceConfig();
        ConnectionPropertiesParser parser = (ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL")));
        ConnectionProperties connectionProps = parser.parse(pipelineDataSourceConfig.getUrl(), null, null);
        ConnectInfo connectInfo = new ConnectInfo(this.generateServerId(), connectionProps.getHostname(), connectionProps.getPort(), pipelineDataSourceConfig.getUsername(), pipelineDataSourceConfig.getPassword());
        log.info("incremental dump, jdbcUrl={}, serverId={}, hostname={}, port={}", new Object[]{pipelineDataSourceConfig.getUrl(), connectInfo.getServerId(), connectInfo.getHost(), connectInfo.getPort()});
        this.client = new MySQLClient(connectInfo, dumperContext.isDecodeWithTX());
        this.catalog = connectionProps.getCatalog();
    }

    private int generateServerId() {
        int result = ((Object)((Object)this)).hashCode();
        return Integer.MIN_VALUE == result ? Integer.MAX_VALUE : Math.abs(result);
    }

    protected void runBlocking() {
        this.client.connect();
        this.client.subscribe(this.binlogPosition.getFilename(), this.binlogPosition.getPosition());
        while (this.isRunning()) {
            List<AbstractBinlogEvent> events = this.client.poll();
            if (events.isEmpty()) continue;
            this.handleEvents(events);
        }
    }

    private void handleEvents(List<AbstractBinlogEvent> events) {
        LinkedList<? extends Record> dataRecords = new LinkedList<Record>();
        for (AbstractBinlogEvent each : events) {
            List<? extends Record> records = this.handleEvent(each);
            dataRecords.addAll(records);
        }
        if (dataRecords.isEmpty()) {
            return;
        }
        this.channel.push(dataRecords);
    }

    private List<? extends Record> handleEvent(AbstractBinlogEvent event) {
        if (!(event instanceof AbstractRowsEvent)) {
            return Collections.singletonList(this.createPlaceholderRecord(event));
        }
        AbstractRowsEvent rowsEvent = (AbstractRowsEvent)event;
        if (!rowsEvent.getDatabaseName().equals(this.catalog) || !this.dumperContext.getCommonContext().getTableNameMapper().containsTable(rowsEvent.getTableName())) {
            return Collections.singletonList(this.createPlaceholderRecord(event));
        }
        PipelineTableMetaData tableMetaData = this.getPipelineTableMetaData(rowsEvent.getTableName());
        if (event instanceof WriteRowsEvent) {
            return this.handleWriteRowsEvent((WriteRowsEvent)event, tableMetaData);
        }
        if (event instanceof UpdateRowsEvent) {
            return this.handleUpdateRowsEvent((UpdateRowsEvent)event, tableMetaData);
        }
        if (event instanceof DeleteRowsEvent) {
            return this.handleDeleteRowsEvent((DeleteRowsEvent)event, tableMetaData);
        }
        return Collections.emptyList();
    }

    private PlaceholderRecord createPlaceholderRecord(AbstractBinlogEvent event) {
        PlaceholderRecord result = new PlaceholderRecord((IngestPosition)new BinlogPosition(event.getFileName(), event.getPosition(), event.getServerId()));
        result.setCommitTime(event.getTimestamp() * 1000L);
        return result;
    }

    private PipelineTableMetaData getPipelineTableMetaData(String actualTableName) {
        CaseInsensitiveIdentifier logicTableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(actualTableName);
        return this.metaDataLoader.getTableMetaData(this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(logicTableName), actualTableName);
    }

    private List<DataRecord> handleWriteRowsEvent(WriteRowsEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (Serializable[] each : event.getAfterRows()) {
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.INSERT, event, each.length);
            for (int i = 0; i < each.length; ++i) {
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(i + 1);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)this.handleValue(columnMetaData, each[i]), true, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private List<DataRecord> handleUpdateRowsEvent(UpdateRowsEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (int i = 0; i < event.getBeforeRows().size(); ++i) {
            Serializable[] beforeValues = event.getBeforeRows().get(i);
            Serializable[] afterValues = event.getAfterRows().get(i);
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.UPDATE, event, beforeValues.length);
            for (int j = 0; j < beforeValues.length; ++j) {
                Serializable newValue = afterValues[j];
                Serializable oldValue = beforeValues[j];
                boolean updated = !Objects.deepEquals(newValue, oldValue);
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(j + 1);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)this.handleValue(columnMetaData, oldValue), (Object)this.handleValue(columnMetaData, newValue), updated, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private List<DataRecord> handleDeleteRowsEvent(DeleteRowsEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (Serializable[] each : event.getBeforeRows()) {
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.DELETE, event, each.length);
            int length = each.length;
            for (int i = 0; i < length; ++i) {
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(i + 1);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)this.handleValue(columnMetaData, each[i]), null, true, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private Serializable handleValue(PipelineColumnMetaData columnMetaData, Serializable value) {
        if (value instanceof MySQLBinaryString) {
            if (PipelineJdbcUtils.isBinaryColumn((int)columnMetaData.getDataType())) {
                return ((MySQLBinaryString)value).getBytes();
            }
            return new String(((MySQLBinaryString)value).getBytes(), Charset.defaultCharset());
        }
        Optional dataTypeHandler = TypedSPILoader.findService(MySQLDataTypeHandler.class, (Object)columnMetaData.getDataTypeName());
        return dataTypeHandler.isPresent() ? ((MySQLDataTypeHandler)dataTypeHandler.get()).handle(value) : value;
    }

    private DataRecord createDataRecord(PipelineSQLOperationType type, AbstractRowsEvent rowsEvent, int columnCount) {
        String tableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(rowsEvent.getTableName()).toString();
        BinlogPosition position = new BinlogPosition(rowsEvent.getFileName(), rowsEvent.getPosition(), rowsEvent.getServerId());
        DataRecord result = new DataRecord(type, tableName, (IngestPosition)position, columnCount);
        result.setActualTableName(rowsEvent.getTableName());
        result.setCommitTime(rowsEvent.getTimestamp() * 1000L);
        return result;
    }

    protected void doStop() {
        if (null != this.client) {
            this.client.closeChannel();
        }
    }
}

