/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.datasource;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ServerVersion;
import org.apache.shardingsphere.data.pipeline.spi.JdbcQueryPropertiesExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLJdbcQueryPropertiesExtension
implements JdbcQueryPropertiesExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLJdbcQueryPropertiesExtension.class);
    private static final String MYSQL_CONNECTOR_VERSION = MySQLJdbcQueryPropertiesExtension.initMysqlConnectorVersion();
    private static final List<String> NOT_OVERRIDE_PROPERTIES = Collections.singletonList("netTimeoutForStreamingResults");
    private final Properties queryProps = new Properties();

    public MySQLJdbcQueryPropertiesExtension() {
        this.queryProps.setProperty("useSSL", Boolean.FALSE.toString());
        this.queryProps.setProperty("useServerPrepStmts", Boolean.FALSE.toString());
        this.queryProps.setProperty("rewriteBatchedStatements", Boolean.TRUE.toString());
        this.queryProps.setProperty("yearIsDateType", Boolean.FALSE.toString());
        this.queryProps.setProperty("zeroDateTimeBehavior", this.getZeroDateTimeBehavior());
        this.queryProps.setProperty("noDatetimeStringSync", Boolean.TRUE.toString());
        this.queryProps.setProperty("jdbcCompliantTruncation", Boolean.FALSE.toString());
        this.queryProps.setProperty("netTimeoutForStreamingResults", "600");
    }

    private String getZeroDateTimeBehavior() {
        String zeroDateTimeBehavior = "convertToNull";
        if (null != MYSQL_CONNECTOR_VERSION) {
            zeroDateTimeBehavior = new ServerVersion(MYSQL_CONNECTOR_VERSION).greaterThanOrEqualTo(8, 0, 0) ? "CONVERT_TO_NULL" : zeroDateTimeBehavior;
        }
        return zeroDateTimeBehavior;
    }

    private static String initMysqlConnectorVersion() {
        try {
            Class<?> mysqlDriverClass = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Driver");
            return mysqlDriverClass.getPackage().getImplementationVersion();
        }
        catch (ClassNotFoundException ex) {
            log.warn("not find com.mysql.jdbc.Driver class");
            return null;
        }
    }

    public void extendQueryProperties(Properties props) {
        for (String each : this.queryProps.stringPropertyNames()) {
            if (NOT_OVERRIDE_PROPERTIES.contains(each) && props.containsKey(each)) continue;
            props.setProperty(each, this.queryProps.getProperty(each));
        }
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

