/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.check.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.checker.DialectDataSourceChecker;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithCheckPrivilegeFailedException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithInvalidSourceDataSourceException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithoutEnoughPrivilegeException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class MySQLDataSourceChecker
implements DialectDataSourceChecker {
    private static final String SHOW_GRANTS_SQL = "SHOW GRANTS";
    private static final String[][] REQUIRED_PRIVILEGES = new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"REPLICATION SLAVE", "REPLICATION CLIENT", "ON *.*"}, {"REPLICATION SLAVE", "BINLOG MONITOR", "ON *.*"}};
    private static final Map<String, String> REQUIRED_VARIABLES = new HashMap<String, String>(3, 1.0f);
    private static final String SHOW_VARIABLES_SQL;

    public void checkPrivilege(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (true) {
                if (resultSet.next()) {
                    String privilege = resultSet.getString(1).toUpperCase();
                    if (!this.matchPrivileges(privilege)) continue;
                    return;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithCheckPrivilegeFailedException(ex);
        }
        throw new PrepareJobWithoutEnoughPrivilegeException(Arrays.asList("REPLICATION SLAVE", "REPLICATION CLIENT"));
    }

    private boolean matchPrivileges(String privilege) {
        return Arrays.stream(REQUIRED_PRIVILEGES).anyMatch(each -> Arrays.stream(each).allMatch(privilege::contains));
    }

    public void checkVariable(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_VARIABLES_SQL);){
            int parameterIndex = 1;
            for (Map.Entry<String, String> entry : REQUIRED_VARIABLES.entrySet()) {
                preparedStatement.setString(parameterIndex++, entry.getKey());
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String key = resultSet.getString(1).toUpperCase();
                    String expectedValue = REQUIRED_VARIABLES.get(key);
                    String actualValue = resultSet.getString(2);
                    ShardingSpherePreconditions.checkState((boolean)expectedValue.equalsIgnoreCase(actualValue), () -> new PrepareJobWithInvalidSourceDataSourceException(key, expectedValue, actualValue));
                }
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithCheckPrivilegeFailedException(ex);
        }
    }

    public String getDatabaseType() {
        return "MySQL";
    }

    static {
        REQUIRED_VARIABLES.put("LOG_BIN", "ON");
        REQUIRED_VARIABLES.put("BINLOG_FORMAT", "ROW");
        REQUIRED_VARIABLES.put("BINLOG_ROW_IMAGE", "FULL");
        SHOW_VARIABLES_SQL = String.format("SHOW VARIABLES WHERE Variable_name IN (%s)", REQUIRED_VARIABLES.keySet().stream().map(each -> "?").collect(Collectors.joining(",")));
    }
}

