/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.sqlbuilder;

import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.AbstractPipelineSQLBuilder;

public final class MySQLPipelineSQLBuilder
extends AbstractPipelineSQLBuilder {
    public MySQLPipelineSQLBuilder() {
    }

    public MySQLPipelineSQLBuilder(Map<String, Set<String>> shardingColumnsMap) {
        super(shardingColumnsMap);
    }

    public String getLeftIdentifierQuoteString() {
        return "`";
    }

    public String getRightIdentifierQuoteString() {
        return "`";
    }

    public String buildInsertSQL(DataRecord dataRecord) {
        return super.buildInsertSQL(dataRecord) + this.buildDuplicateUpdateSQL(dataRecord);
    }

    private String buildDuplicateUpdateSQL(DataRecord dataRecord) {
        StringBuilder result = new StringBuilder(" ON DUPLICATE KEY UPDATE ");
        for (int i = 0; i < dataRecord.getColumnCount(); ++i) {
            Column column = dataRecord.getColumn(i);
            if (column.isPrimaryKey() || this.isShardingColumn(this.getShardingColumnsMap(), dataRecord.getTableName(), column.getName())) continue;
            result.append((CharSequence)this.quote(column.getName())).append("=VALUES(").append((CharSequence)this.quote(column.getName())).append("),");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    private boolean isShardingColumn(Map<String, Set<String>> shardingColumnsMap, String tableName, String columnName) {
        return shardingColumnsMap.containsKey(tableName) && shardingColumnsMap.get(tableName).contains(columnName);
    }

    public String buildCRC32SQL(String tableName, String column) {
        return String.format("SELECT BIT_XOR(CAST(CRC32(%s) AS UNSIGNED)) AS checksum FROM %s", this.quote(column), this.quote(tableName));
    }

    public String getType() {
        return "MySQL";
    }
}

