/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.column.value;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.column.value.ValueHandler;

public final class UnsignedBigintHandler
implements ValueHandler {
    private static final BigInteger BIGINT_MODULO = new BigInteger("18446744073709551616");

    @Override
    public String getTypeName() {
        return "BIGINT UNSIGNED";
    }

    @Override
    public Serializable handle(Serializable value) {
        long longValue = (Long)value;
        return 0L > longValue ? BIGINT_MODULO.add(BigInteger.valueOf(longValue)) : Long.valueOf(longValue);
    }
}

