/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthMoreDataPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchRequestPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakePacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLNegotiatePackageDecoder
extends ByteToMessageDecoder {
    private boolean handshakeReceived;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        if (!this.handshakeReceived) {
            out.add(this.decodeHandshakePacket(payload));
            this.handshakeReceived = true;
        } else {
            MySQLPacket responsePacket = this.decodeResponsePacket(payload, out);
            if (responsePacket instanceof MySQLOKPacket) {
                ctx.channel().pipeline().remove((ChannelHandler)this);
            }
            out.add(responsePacket);
        }
    }

    private MySQLHandshakePacket decodeHandshakePacket(MySQLPacketPayload payload) {
        MySQLHandshakePacket result = new MySQLHandshakePacket(payload);
        return result;
    }

    private MySQLPacket decodeResponsePacket(MySQLPacketPayload payload, List<Object> out) {
        int header = payload.getByteBuf().getByte(1) & 0xFF;
        switch (header) {
            case 255: {
                return new MySQLErrPacket(payload);
            }
            case 0: {
                return new MySQLOKPacket(payload);
            }
            case 254: {
                return new MySQLAuthSwitchRequestPacket(payload);
            }
            case 1: {
                return new MySQLAuthMoreDataPacket(payload);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported negotiate response header: %X", header));
    }
}

