/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.InternalResultSet;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLFieldCountPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLCommandPacketDecoder
extends ByteToMessageDecoder {
    private States currentState = States.ResponsePacket;
    private InternalResultSet internalResultSet;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        this.decodeCommandPacket(payload, out);
    }

    private void decodeCommandPacket(MySQLPacketPayload payload, List<Object> out) {
        if (States.FieldPacket == this.currentState) {
            this.decodeFieldPacket(payload);
            return;
        }
        if (States.RowDataPacket == this.currentState) {
            this.decodeRowDataPacket(payload, out);
            return;
        }
        this.decodeResponsePacket(payload, out);
    }

    private void decodeFieldPacket(MySQLPacketPayload payload) {
        if (254 != (payload.getByteBuf().getByte(1) & 0xFF)) {
            this.internalResultSet.getFieldDescriptors().add(new MySQLColumnDefinition41Packet(payload));
        } else {
            new MySQLEofPacket(payload);
            this.currentState = States.RowDataPacket;
        }
    }

    private void decodeRowDataPacket(MySQLPacketPayload payload, List<Object> out) {
        if (254 != (payload.getByteBuf().getByte(1) & 0xFF)) {
            this.internalResultSet.getFieldValues().add(new MySQLTextResultSetRowPacket(payload, this.internalResultSet.getHeader().getColumnCount()));
        } else {
            new MySQLEofPacket(payload);
            out.add(this.internalResultSet);
            this.currentState = States.ResponsePacket;
            this.internalResultSet = null;
        }
    }

    private void decodeResponsePacket(MySQLPacketPayload payload, List<Object> out) {
        switch (payload.getByteBuf().getByte(1) & 0xFF) {
            case 255: {
                out.add(new MySQLErrPacket(payload));
                break;
            }
            case 0: {
                out.add(new MySQLOKPacket(payload));
                break;
            }
            default: {
                MySQLFieldCountPacket fieldCountPacket = new MySQLFieldCountPacket(payload);
                this.currentState = States.FieldPacket;
                this.internalResultSet = new InternalResultSet(fieldCountPacket);
            }
        }
    }

    private static enum States {
        ResponsePacket,
        FieldPacket,
        RowDataPacket;

    }
}

