/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.BinlogContext;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.DeleteRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.PlaceholderEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.UpdateRowsEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.WriteRowsEvent;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinlogEventType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.management.MySQLBinlogFormatDescriptionEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.management.MySQLBinlogRotateEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogRowsEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.MySQLBinlogTableMapEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLBinlogEventPacketDecoder
extends ByteToMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLBinlogEventPacketDecoder.class);
    private final BinlogContext binlogContext = new BinlogContext();

    public MySQLBinlogEventPacketDecoder(int checksumLength) {
        this.binlogContext.setChecksumLength(checksumLength);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        this.skipSequenceId(payload);
        this.checkError(payload);
        MySQLBinlogEventHeader binlogEventHeader = new MySQLBinlogEventHeader(payload);
        this.removeChecksum(binlogEventHeader.getEventType(), in);
        switch (MySQLBinlogEventType.valueOf((int)binlogEventHeader.getEventType())) {
            case ROTATE_EVENT: {
                this.decodeRotateEvent(binlogEventHeader, payload);
                break;
            }
            case FORMAT_DESCRIPTION_EVENT: {
                new MySQLBinlogFormatDescriptionEventPacket(binlogEventHeader, payload);
                break;
            }
            case TABLE_MAP_EVENT: {
                this.decodeTableMapEvent(binlogEventHeader, payload);
                break;
            }
            case WRITE_ROWS_EVENTv1: 
            case WRITE_ROWS_EVENTv2: {
                out.add(this.decodeWriteRowsEventV2(binlogEventHeader, payload));
                break;
            }
            case UPDATE_ROWS_EVENTv1: 
            case UPDATE_ROWS_EVENTv2: {
                out.add(this.decodeUpdateRowsEventV2(binlogEventHeader, payload));
                break;
            }
            case DELETE_ROWS_EVENTv1: 
            case DELETE_ROWS_EVENTv2: {
                out.add(this.decodeDeleteRowsEventV2(binlogEventHeader, payload));
                break;
            }
            default: {
                out.add(this.createPlaceholderEvent(binlogEventHeader));
                payload.skipReserved(payload.getByteBuf().readableBytes());
            }
        }
        if (in.isReadable()) {
            throw new UnsupportedOperationException(String.format("Do not parse binlog event fully, eventHeader: %s, remaining packet %s", binlogEventHeader, this.readRemainPacket(payload)));
        }
    }

    private void skipSequenceId(MySQLPacketPayload payload) {
        payload.readInt1();
    }

    private void checkError(MySQLPacketPayload payload) {
        int statusCode = payload.readInt1();
        if (255 == statusCode) {
            int errorNo = payload.readInt2();
            payload.skipReserved(1);
            String sqlState = payload.readStringFix(5);
            throw new RuntimeException(String.format("Decode binlog event failed, errorCode: %d, sqlState: %s, errorMessage: %s", errorNo, sqlState, payload.readStringEOF()));
        }
        if (0 != statusCode && log.isDebugEnabled()) {
            log.debug("Illegal binlog status code {}, remaining packet \n{}", (Object)statusCode, (Object)this.readRemainPacket(payload));
        }
    }

    private String readRemainPacket(MySQLPacketPayload payload) {
        return ByteBufUtil.hexDump((byte[])payload.readStringFixByBytes(payload.getByteBuf().readableBytes()));
    }

    private void removeChecksum(int eventType, ByteBuf in) {
        if (0 < this.binlogContext.getChecksumLength() && MySQLBinlogEventType.FORMAT_DESCRIPTION_EVENT.getValue() != eventType) {
            in.writerIndex(in.writerIndex() - this.binlogContext.getChecksumLength());
        }
    }

    private void decodeRotateEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRotateEventPacket rotateEventPacket = new MySQLBinlogRotateEventPacket(binlogEventHeader, payload);
        this.binlogContext.setFileName(rotateEventPacket.getNextBinlogName());
    }

    private void decodeTableMapEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogTableMapEventPacket tableMapEventPacket = new MySQLBinlogTableMapEventPacket(binlogEventHeader, payload);
        this.binlogContext.putTableMapEvent(tableMapEventPacket.getTableId(), tableMapEventPacket);
    }

    private DeleteRowsEvent decodeDeleteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket rowsEventPacket = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        rowsEventPacket.readRows(this.binlogContext.getTableMapEvent(rowsEventPacket.getTableId()), payload);
        DeleteRowsEvent result = new DeleteRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, rowsEventPacket.getTableId());
        result.setBeforeRows(rowsEventPacket.getRows());
        return result;
    }

    private UpdateRowsEvent decodeUpdateRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket rowsEventPacket = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        rowsEventPacket.readRows(this.binlogContext.getTableMapEvent(rowsEventPacket.getTableId()), payload);
        UpdateRowsEvent result = new UpdateRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, rowsEventPacket.getTableId());
        result.setBeforeRows(rowsEventPacket.getRows());
        result.setAfterRows(rowsEventPacket.getRows2());
        return result;
    }

    private WriteRowsEvent decodeWriteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket rowsEventPacket = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        rowsEventPacket.readRows(this.binlogContext.getTableMapEvent(rowsEventPacket.getTableId()), payload);
        WriteRowsEvent result = new WriteRowsEvent();
        this.initRowsEvent(result, binlogEventHeader, rowsEventPacket.getTableId());
        result.setAfterRows(rowsEventPacket.getRows());
        return result;
    }

    private void initRowsEvent(AbstractRowsEvent rowsEvent, MySQLBinlogEventHeader binlogEventHeader, long tableId) {
        rowsEvent.setSchemaName(this.binlogContext.getSchemaName(tableId));
        rowsEvent.setTableName(this.binlogContext.getTableName(tableId));
        rowsEvent.setFileName(this.binlogContext.getFileName());
        rowsEvent.setPosition(binlogEventHeader.getLogPos());
        rowsEvent.setTimestamp(binlogEventHeader.getTimestamp());
        rowsEvent.setServerId(binlogEventHeader.getServerId());
    }

    private PlaceholderEvent createPlaceholderEvent(MySQLBinlogEventHeader binlogEventHeader) {
        PlaceholderEvent result = new PlaceholderEvent();
        result.setFileName(this.binlogContext.getFileName());
        result.setPosition(binlogEventHeader.getLogPos());
        result.setTimestamp(binlogEventHeader.getTimestamp());
        return result;
    }
}

