/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ServerVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+).*");
    private int major;
    private int minor;
    private int series;

    public ServerVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Short.parseShort(matcher.group(1));
            this.minor = Short.parseShort(matcher.group(2));
            this.series = Short.parseShort(matcher.group(3));
        }
    }

    public boolean greaterThanOrEqualTo(int major, int minor, int series) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        return this.series >= series;
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public int getSeries() {
        return this.series;
    }
}

