/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.binlog.event.AbstractBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ConnectInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.InternalResultSet;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.ServerInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty.MySQLBinlogEventPacketDecoder;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty.MySQLCommandPacketDecoder;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty.MySQLNegotiateHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.client.netty.MySQLNegotiatePackageDecoder;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.codec.PacketCodec;
import org.apache.shardingsphere.db.protocol.mysql.codec.MySQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.binlog.MySQLComBinlogDumpCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.binlog.MySQLComRegisterSlaveCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.netty.ChannelAttrInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLClient.class);
    private final ConnectInfo connectInfo;
    private EventLoopGroup eventLoopGroup;
    private Channel channel;
    private Promise<Object> responseCallback;
    private final ArrayBlockingQueue<AbstractBinlogEvent> blockingEventQueue = new ArrayBlockingQueue(10000);
    private ServerInfo serverInfo;

    public synchronized void connect() {
        this.eventLoopGroup = new NioEventLoopGroup(1);
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new ChannelAttrInitializer()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new PacketCodec((DatabasePacketCodecEngine)new MySQLPacketCodecEngine())});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLNegotiatePackageDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLCommandPacketDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLNegotiateHandler(MySQLClient.this.connectInfo.getUsername(), MySQLClient.this.connectInfo.getPassword(), (Promise<Object>)MySQLClient.this.responseCallback)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLCommandResponseHandler()});
            }
        })).connect(this.connectInfo.getHost(), this.connectInfo.getPort()).channel();
        this.serverInfo = this.waitExpectedResponse(ServerInfo.class);
    }

    public synchronized boolean execute(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.channel.writeAndFlush((Object)comQueryPacket);
        return null != this.waitExpectedResponse(MySQLOKPacket.class);
    }

    public synchronized int executeUpdate(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.channel.writeAndFlush((Object)comQueryPacket);
        return (int)Objects.requireNonNull(this.waitExpectedResponse(MySQLOKPacket.class)).getAffectedRows();
    }

    public synchronized InternalResultSet executeQuery(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.channel.writeAndFlush((Object)comQueryPacket);
        return this.waitExpectedResponse(InternalResultSet.class);
    }

    public synchronized void subscribe(String binlogFileName, long binlogPosition) {
        this.initDumpConnectSession();
        this.registerSlave();
        this.dumpBinlog(binlogFileName, binlogPosition, this.queryChecksumLength());
    }

    private void initDumpConnectSession() {
        if (this.serverInfo.getServerVersion().greaterThanOrEqualTo(5, 6, 0)) {
            this.execute("SET @MASTER_BINLOG_CHECKSUM= @@GLOBAL.BINLOG_CHECKSUM");
        }
    }

    private void registerSlave() {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        InetSocketAddress localAddress = (InetSocketAddress)this.channel.localAddress();
        MySQLComRegisterSlaveCommandPacket packet = new MySQLComRegisterSlaveCommandPacket(this.connectInfo.getServerId(), localAddress.getHostName(), this.connectInfo.getUsername(), this.connectInfo.getPassword(), localAddress.getPort());
        this.channel.writeAndFlush((Object)packet);
        this.waitExpectedResponse(MySQLOKPacket.class);
    }

    private int queryChecksumLength() {
        String checksumType;
        if (!this.serverInfo.getServerVersion().greaterThanOrEqualTo(5, 6, 0)) {
            return 0;
        }
        InternalResultSet resultSet = this.executeQuery("SELECT @@GLOBAL.BINLOG_CHECKSUM");
        switch (checksumType = resultSet.getFieldValues().get(0).getData().iterator().next().toString()) {
            case "None": {
                return 0;
            }
            case "CRC32": {
                return 4;
            }
        }
        throw new UnsupportedOperationException(checksumType);
    }

    private void dumpBinlog(String binlogFileName, long binlogPosition, int checksumLength) {
        this.responseCallback = null;
        this.channel.pipeline().remove(MySQLCommandPacketDecoder.class);
        this.channel.pipeline().remove(MySQLCommandResponseHandler.class);
        this.channel.pipeline().addLast(new ChannelHandler[]{new MySQLBinlogEventPacketDecoder(checksumLength)});
        this.channel.pipeline().addLast(new ChannelHandler[]{new MySQLBinlogEventHandler()});
        this.channel.writeAndFlush((Object)new MySQLComBinlogDumpCommandPacket((int)binlogPosition, this.connectInfo.getServerId(), binlogFileName));
    }

    public synchronized AbstractBinlogEvent poll() {
        try {
            return this.blockingEventQueue.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            return null;
        }
    }

    private <T> T waitExpectedResponse(Class<T> type) {
        try {
            Object response = this.responseCallback.get();
            if (null == response) {
                return null;
            }
            if (type.equals(response.getClass())) {
                return (T)response;
            }
            if (response instanceof MySQLErrPacket) {
                throw new RuntimeException(((MySQLErrPacket)response).getErrorMessage());
            }
            throw new RuntimeException("unexpected response type");
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Generated
    public MySQLClient(ConnectInfo connectInfo) {
        this.connectInfo = connectInfo;
    }

    private final class MySQLBinlogEventHandler
    extends ChannelInboundHandlerAdapter {
        private AbstractBinlogEvent lastBinlogEvent;

        private MySQLBinlogEventHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof AbstractBinlogEvent) {
                this.lastBinlogEvent = (AbstractBinlogEvent)msg;
                MySQLClient.this.blockingEventQueue.put(this.lastBinlogEvent);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            log.warn("channel inactive");
            this.reconnect();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("protocol resolution error", cause);
            this.reconnect();
        }

        private void reconnect() {
            log.info("reconnect mysql client.");
            this.closeOldChannel();
            MySQLClient.this.connect();
            MySQLClient.this.subscribe(this.lastBinlogEvent.getFileName(), this.lastBinlogEvent.getPosition());
        }

        private void closeOldChannel() {
            try {
                MySQLClient.this.channel.closeFuture().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final class MySQLCommandResponseHandler
    extends ChannelInboundHandlerAdapter {
        private MySQLCommandResponseHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (null != MySQLClient.this.responseCallback) {
                MySQLClient.this.responseCallback.setSuccess(msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (null != MySQLClient.this.responseCallback) {
                MySQLClient.this.responseCallback.setFailure(cause);
                log.error("protocol resolution error", cause);
            }
        }
    }
}

