/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.AbstractInventoryDumper;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;

public final class MySQLInventoryDumper
extends AbstractInventoryDumper {
    private static final String YEAR_DATA_TYPE = "YEAR";

    public MySQLInventoryDumper(InventoryDumperConfiguration inventoryDumperConfig, PipelineChannel channel, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader) {
        super(inventoryDumperConfig, channel, dataSource, metaDataLoader);
        Properties queryProps = new Properties();
        queryProps.setProperty("yearIsDateType", Boolean.FALSE.toString());
        inventoryDumperConfig.getDataSourceConfig().appendJDBCQueryProperties(queryProps);
    }

    public Object readValue(ResultSet resultSet, int index) throws SQLException {
        if (this.isYearDataType(resultSet.getMetaData().getColumnTypeName(index))) {
            Object result = resultSet.getObject(index);
            return resultSet.wasNull() ? null : result;
        }
        if (this.isDateTimeValue(resultSet.getMetaData().getColumnType(index))) {
            return resultSet.getString(index);
        }
        return resultSet.getObject(index);
    }

    private boolean isDateTimeValue(int columnType) {
        return 92 == columnType || 91 == columnType || 93 == columnType;
    }

    private boolean isYearDataType(String columnDataTypeName) {
        return YEAR_DATA_TYPE.equalsIgnoreCase(columnDataTypeName);
    }

    protected PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement result = connection.prepareStatement(sql, 1003, 1007);
        result.setFetchSize(Integer.MIN_VALUE);
        return result;
    }
}

