/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.check.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.check.datasource.AbstractDataSourceChecker;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;

public final class MySQLDataSourceChecker
extends AbstractDataSourceChecker {
    private static final String SHOW_GRANTS_SQL = "SHOW GRANTS";
    private static final String[][] REQUIRED_PRIVILEGES = new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"REPLICATION SLAVE", "REPLICATION CLIENT", "ON *.*"}};
    private static final String SHOW_VARIABLES_SQL = "SHOW VARIABLES LIKE ?";
    private static final Map<String, String> REQUIRED_VARIABLES = new HashMap<String, String>(3, 1.0f);
    private static final String BINLOG_ROW_IMAGE = "BINLOG_ROW_IMAGE";

    public void checkPrivilege(Collection<? extends DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            this.checkPrivilege(dataSource);
        }
    }

    private void checkPrivilege(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (true) {
                if (resultSet.next()) {
                    String privilege = resultSet.getString(1).toUpperCase();
                    if (!this.matchPrivileges(privilege)) continue;
                    return;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Source data source check privileges failed.", (Throwable)ex);
        }
        throw new PipelineJobPrepareFailedException("Source data source is lack of REPLICATION SLAVE, REPLICATION CLIENT ON *.* privileges.");
    }

    private boolean matchPrivileges(String privilege) {
        return Arrays.stream(REQUIRED_PRIVILEGES).anyMatch(each -> Arrays.stream(each).allMatch(privilege::contains));
    }

    public void checkVariable(Collection<? extends DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            this.checkVariable(dataSource);
        }
    }

    private void checkVariable(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            for (Map.Entry<String, String> entry : REQUIRED_VARIABLES.entrySet()) {
                this.checkVariable(connection, entry.getKey(), entry.getValue());
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Source data source check variables failed.", (Throwable)ex);
        }
    }

    private void checkVariable(Connection connection, String key, String toBeCheckedValue) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(SHOW_VARIABLES_SQL);){
            preparedStatement.setString(1, key);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next() && BINLOG_ROW_IMAGE.equalsIgnoreCase(key)) {
                    return;
                }
                String actualValue = resultSet.getString(2);
                if (!toBeCheckedValue.equalsIgnoreCase(actualValue)) {
                    throw new PipelineJobPrepareFailedException(String.format("Source data source required `%s = %s`, now is `%s`", key, toBeCheckedValue, actualValue));
                }
            }
        }
    }

    protected String getDatabaseType() {
        return "MySQL";
    }

    static {
        REQUIRED_VARIABLES.put("LOG_BIN", "ON");
        REQUIRED_VARIABLES.put("BINLOG_FORMAT", "ROW");
        REQUIRED_VARIABLES.put(BINLOG_ROW_IMAGE, "FULL");
    }
}

