/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.migration.distsql.parser.core;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.MigrationDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.MigrationDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.migration.distsql.statement.CheckMigrationStatement;
import org.apache.shardingsphere.migration.distsql.statement.CommitMigrationStatement;
import org.apache.shardingsphere.migration.distsql.statement.DropMigrationCheckStatement;
import org.apache.shardingsphere.migration.distsql.statement.MigrateTableStatement;
import org.apache.shardingsphere.migration.distsql.statement.RegisterMigrationSourceStorageUnitStatement;
import org.apache.shardingsphere.migration.distsql.statement.RollbackMigrationStatement;
import org.apache.shardingsphere.migration.distsql.statement.ShowMigrationCheckAlgorithmsStatement;
import org.apache.shardingsphere.migration.distsql.statement.ShowMigrationCheckStatusStatement;
import org.apache.shardingsphere.migration.distsql.statement.ShowMigrationListStatement;
import org.apache.shardingsphere.migration.distsql.statement.ShowMigrationSourceStorageUnitsStatement;
import org.apache.shardingsphere.migration.distsql.statement.ShowMigrationStatusStatement;
import org.apache.shardingsphere.migration.distsql.statement.StartMigrationCheckStatement;
import org.apache.shardingsphere.migration.distsql.statement.StartMigrationStatement;
import org.apache.shardingsphere.migration.distsql.statement.StopMigrationCheckStatement;
import org.apache.shardingsphere.migration.distsql.statement.StopMigrationStatement;
import org.apache.shardingsphere.migration.distsql.statement.UnregisterMigrationSourceStorageUnitStatement;
import org.apache.shardingsphere.migration.distsql.statement.pojo.SourceTargetEntry;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class MigrationDistSQLStatementVisitor
extends MigrationDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitMigrateTable(MigrationDistSQLStatementParser.MigrateTableContext ctx) {
        List source = Splitter.on((char)'.').splitToList((CharSequence)this.getIdentifierValue((ParseTree)ctx.sourceTableName()));
        List target = Splitter.on((char)'.').splitToList((CharSequence)this.getIdentifierValue((ParseTree)ctx.targetTableName()));
        String sourceResourceName = (String)source.get(0);
        String sourceSchemaName = 3 == source.size() ? (String)source.get(1) : null;
        String sourceTableName = (String)source.get(source.size() - 1);
        String targetDatabaseName = target.size() > 1 ? (String)target.get(0) : null;
        String targetTableName = (String)target.get(target.size() - 1);
        SourceTargetEntry sourceTargetEntry = new SourceTargetEntry(targetDatabaseName, new DataNode(sourceResourceName, sourceTableName), targetTableName);
        sourceTargetEntry.getSource().setSchemaName(sourceSchemaName);
        return new MigrateTableStatement(Collections.singletonList(sourceTargetEntry), targetDatabaseName);
    }

    @Override
    public ASTNode visitShowMigrationList(MigrationDistSQLStatementParser.ShowMigrationListContext ctx) {
        return new ShowMigrationListStatement();
    }

    @Override
    public ASTNode visitShowMigrationStatus(MigrationDistSQLStatementParser.ShowMigrationStatusContext ctx) {
        return new ShowMigrationStatusStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStartMigration(MigrationDistSQLStatementParser.StartMigrationContext ctx) {
        return new StartMigrationStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStopMigration(MigrationDistSQLStatementParser.StopMigrationContext ctx) {
        return new StopMigrationStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitRollbackMigration(MigrationDistSQLStatementParser.RollbackMigrationContext ctx) {
        return new RollbackMigrationStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitCommitMigration(MigrationDistSQLStatementParser.CommitMigrationContext ctx) {
        return new CommitMigrationStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitCheckMigration(MigrationDistSQLStatementParser.CheckMigrationContext ctx) {
        return new CheckMigrationStatement(this.getIdentifierValue((ParseTree)ctx.jobId()), null == ctx.algorithmDefinition() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitShowMigrationCheckAlgorithms(MigrationDistSQLStatementParser.ShowMigrationCheckAlgorithmsContext ctx) {
        return new ShowMigrationCheckAlgorithmsStatement();
    }

    @Override
    public ASTNode visitAlgorithmDefinition(MigrationDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitStorageUnitDefinition(MigrationDistSQLStatementParser.StorageUnitDefinitionContext ctx) {
        String user = this.getIdentifierValue((ParseTree)ctx.user());
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        return null != ctx.urlSource() ? new URLBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.urlSource().url()), user, password, props) : new HostnameAndPortBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.simpleSource().hostname()), ctx.simpleSource().port().getText(), this.getIdentifierValue((ParseTree)ctx.simpleSource().dbName()), user, password, props);
    }

    private String getPassword(MigrationDistSQLStatementParser.PasswordContext ctx) {
        return this.getIdentifierValue((ParseTree)ctx);
    }

    private Properties getProperties(MigrationDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (MigrationDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitRegisterMigrationSourceStorageUnit(MigrationDistSQLStatementParser.RegisterMigrationSourceStorageUnitContext ctx) {
        LinkedList<DataSourceSegment> dataSources = new LinkedList<DataSourceSegment>();
        for (MigrationDistSQLStatementParser.StorageUnitDefinitionContext each : ctx.storageUnitDefinition()) {
            dataSources.add((DataSourceSegment)this.visit((ParseTree)each));
        }
        return new RegisterMigrationSourceStorageUnitStatement(dataSources);
    }

    @Override
    public ASTNode visitUnregisterMigrationSourceStorageUnit(MigrationDistSQLStatementParser.UnregisterMigrationSourceStorageUnitContext ctx) {
        return new UnregisterMigrationSourceStorageUnitStatement((Collection)ctx.storageUnitName().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowMigrationSourceStorageUnits(MigrationDistSQLStatementParser.ShowMigrationSourceStorageUnitsContext ctx) {
        return new ShowMigrationSourceStorageUnitsStatement();
    }

    @Override
    public ASTNode visitShowMigrationCheckStatus(MigrationDistSQLStatementParser.ShowMigrationCheckStatusContext ctx) {
        return new ShowMigrationCheckStatusStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStartMigrationCheck(MigrationDistSQLStatementParser.StartMigrationCheckContext ctx) {
        return new StartMigrationCheckStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStopMigrationCheck(MigrationDistSQLStatementParser.StopMigrationCheckContext ctx) {
        return new StopMigrationCheckStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitDropMigrationCheck(MigrationDistSQLStatementParser.DropMigrationCheckContext ctx) {
        return new DropMigrationCheckStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }
}

