/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.yaml.job;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.cdc.config.job.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.constant.CDCSinkType;
import org.apache.shardingsphere.data.pipeline.cdc.yaml.job.YamlCDCJobConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;

public final class YamlCDCJobConfigurationSwapper
implements YamlConfigurationSwapper<YamlCDCJobConfiguration, CDCJobConfiguration> {
    private final YamlPipelineDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();

    public YamlCDCJobConfiguration swapToYamlConfiguration(CDCJobConfiguration data) {
        YamlCDCJobConfiguration result = new YamlCDCJobConfiguration();
        result.setJobId(data.getJobId());
        result.setDatabaseName(data.getDatabaseName());
        result.setSchemaTableNames(data.getSchemaTableNames());
        result.setFull(data.isFull());
        result.setSourceDatabaseType(data.getSourceDatabaseType());
        result.setDataSourceConfiguration(this.dataSourceConfigSwapper.swapToYamlConfiguration((PipelineDataSourceConfiguration)data.getDataSourceConfig()));
        result.setTablesFirstDataNodes(null == data.getTablesFirstDataNodes() ? null : data.getTablesFirstDataNodes().marshal());
        List jobShardingDataNodes = null == data.getJobShardingDataNodes() ? null : data.getJobShardingDataNodes().stream().map(JobDataNodeLine::marshal).collect(Collectors.toList());
        result.setJobShardingDataNodes(jobShardingDataNodes);
        result.setDecodeWithTX(data.isDecodeWithTX());
        result.setSinkConfig(this.swapToYamlSinkConfiguration(data.getSinkConfig()));
        result.setConcurrency(data.getConcurrency());
        result.setRetryTimes(0);
        return result;
    }

    private YamlCDCJobConfiguration.YamlSinkConfiguration swapToYamlSinkConfiguration(CDCJobConfiguration.SinkConfiguration sinkConfig) {
        YamlCDCJobConfiguration.YamlSinkConfiguration result = new YamlCDCJobConfiguration.YamlSinkConfiguration();
        result.setSinkType(sinkConfig.getSinkType().name());
        result.setProps(sinkConfig.getProps());
        return result;
    }

    public CDCJobConfiguration swapToObject(YamlCDCJobConfiguration yamlConfig) {
        List<JobDataNodeLine> jobShardingDataNodes = null == yamlConfig.getJobShardingDataNodes() ? Collections.emptyList() : yamlConfig.getJobShardingDataNodes().stream().map(JobDataNodeLine::unmarshal).collect(Collectors.toList());
        YamlCDCJobConfiguration.YamlSinkConfiguration yamlSinkConfig = yamlConfig.getSinkConfig();
        CDCJobConfiguration.SinkConfiguration sinkConfig = new CDCJobConfiguration.SinkConfiguration(CDCSinkType.valueOf(yamlSinkConfig.getSinkType()), yamlSinkConfig.getProps());
        JobDataNodeLine tablesFirstDataNodes = null == yamlConfig.getTablesFirstDataNodes() ? null : JobDataNodeLine.unmarshal((String)yamlConfig.getTablesFirstDataNodes());
        return new CDCJobConfiguration(yamlConfig.getJobId(), yamlConfig.getDatabaseName(), yamlConfig.getSchemaTableNames(), yamlConfig.isFull(), yamlConfig.getSourceDatabaseType(), (ShardingSpherePipelineDataSourceConfiguration)this.dataSourceConfigSwapper.swapToObject(yamlConfig.getDataSourceConfiguration()), tablesFirstDataNodes, jobShardingDataNodes, yamlConfig.isDecodeWithTX(), sinkConfig, yamlConfig.getConcurrency(), yamlConfig.getRetryTimes());
    }

    public CDCJobConfiguration swapToObject(String jobParam) {
        return null == jobParam ? null : this.swapToObject((YamlCDCJobConfiguration)YamlEngine.unmarshal((String)jobParam, YamlCDCJobConfiguration.class, (boolean)true));
    }
}

