/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.DataRecordResult;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.TableColumn;
import org.apache.shardingsphere.data.pipeline.cdc.util.ColumnValueConvertUtil;

public final class DataRecordResultConvertUtil {
    public static DataRecordResult.Record convertDataRecordToRecord(String database, String schema, DataRecord dataRecord) {
        LinkedList<TableColumn> before = new LinkedList<TableColumn>();
        LinkedList<TableColumn> after = new LinkedList<TableColumn>();
        for (Column column : dataRecord.getColumns()) {
            before.add(TableColumn.newBuilder().setName(column.getName()).setValue(Any.pack((Message)ColumnValueConvertUtil.convertToProtobufMessage(column.getOldValue()))).build());
            after.add(TableColumn.newBuilder().setName(column.getName()).setValue(Any.pack((Message)ColumnValueConvertUtil.convertToProtobufMessage(column.getValue()))).build());
        }
        DataRecordResult.Record.MetaData metaData = DataRecordResult.Record.MetaData.newBuilder().setDatabase(database).setSchema(Strings.nullToEmpty((String)schema)).setTable(dataRecord.getTableName()).build();
        DataRecordResult.Record.DataChangeType dataChangeType = DataRecordResult.Record.DataChangeType.UNKNOWN;
        if ("INSERT".equals(dataRecord.getType())) {
            dataChangeType = DataRecordResult.Record.DataChangeType.INSERT;
        } else if ("UPDATE".equals(dataRecord.getType())) {
            dataChangeType = DataRecordResult.Record.DataChangeType.UPDATE;
        } else if ("DELETE".equals(dataRecord.getType())) {
            dataChangeType = DataRecordResult.Record.DataChangeType.DELETE;
        }
        return DataRecordResult.Record.newBuilder().setMetaData(metaData).addAllBefore(before).addAllAfter(after).setDataChangeType(dataChangeType).build();
    }
}

