/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StreamDataRequestBody;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.SchemaSupportedDatabaseType;
import org.apache.shardingsphere.infra.exception.SchemaNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class CDCSchemaTableUtil {
    public static Map<String, Set<String>> parseTableExpressionWithSchema(ShardingSphereDatabase database, Collection<StreamDataRequestBody.SchemaTable> schemaTables) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Collection systemSchemas = database.getProtocolType().getSystemSchemas();
        Optional<StreamDataRequestBody.SchemaTable> allSchemaTablesOptional = schemaTables.stream().filter(each -> "*".equals(each.getTable()) && ("*".equals(each.getSchema()) || each.getSchema().isEmpty())).findFirst();
        if (allSchemaTablesOptional.isPresent()) {
            for (Map.Entry entry : database.getSchemas().entrySet()) {
                if (systemSchemas.contains(entry.getKey())) continue;
                ((ShardingSphereSchema)entry.getValue()).getAllTableNames().forEach(tableName -> result.computeIfAbsent((String)entry.getKey(), ignored -> new HashSet()).add(tableName));
            }
            return result;
        }
        for (StreamDataRequestBody.SchemaTable each2 : schemaTables) {
            if ("*".equals(each2.getSchema())) {
                for (Map.Entry entry : database.getSchemas().entrySet()) {
                    if (systemSchemas.contains(entry.getKey())) continue;
                    ((ShardingSphereSchema)entry.getValue()).getAllTableNames().stream().filter(tableName -> tableName.equals(each2.getTable())).findFirst().ifPresent(tableName -> result.computeIfAbsent((String)entry.getKey(), ignored -> new HashSet()).add(tableName));
                }
                continue;
            }
            if ("*".equals(each2.getTable())) {
                String schemaName = each2.getSchema().isEmpty() ? CDCSchemaTableUtil.getDefaultSchema(database.getProtocolType()) : each2.getSchema();
                ShardingSphereSchema schema = database.getSchema(schemaName);
                if (null == schema) {
                    throw new SchemaNotFoundException(each2.getSchema());
                }
                schema.getAllTableNames().forEach(tableName -> result.computeIfAbsent(schemaName, ignored -> new HashSet()).add(tableName));
                continue;
            }
            result.computeIfAbsent(each2.getSchema(), ignored -> new HashSet()).add(each2.getTable());
        }
        return result;
    }

    private static String getDefaultSchema(DatabaseType databaseType) {
        if (!(databaseType instanceof SchemaSupportedDatabaseType)) {
            return null;
        }
        return ((SchemaSupportedDatabaseType)databaseType).getDefaultSchema();
    }

    public static Collection<String> parseTableExpressionWithoutSchema(ShardingSphereDatabase database, List<String> tableNames) {
        Optional<String> allTablesOptional = tableNames.stream().filter("*"::equals).findFirst();
        HashSet<String> allTableNames = new HashSet<String>(database.getSchema(database.getName()).getAllTableNames());
        return allTablesOptional.isPresent() ? allTableNames : new HashSet<String>(tableNames);
    }
}

