/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckPosition;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.SocketSinkImporter;

public final class CDCDataRecordUtil {
    public static DataRecord findMinimumDataRecordAndSavePosition(Map<SocketSinkImporter, BlockingQueue<Record>> incrementalRecordMap, Comparator<DataRecord> dataRecordComparator, Map<SocketSinkImporter, CDCAckPosition> cdcAckPositionMap) {
        if (null == dataRecordComparator) {
            return CDCDataRecordUtil.findMinimumDataRecordWithoutComparator(incrementalRecordMap, cdcAckPositionMap);
        }
        return CDCDataRecordUtil.findMinimumDataRecordWithComparator(incrementalRecordMap, cdcAckPositionMap, dataRecordComparator);
    }

    private static DataRecord findMinimumDataRecordWithoutComparator(Map<SocketSinkImporter, BlockingQueue<Record>> incrementalRecordMap, Map<SocketSinkImporter, CDCAckPosition> cdcAckPositionMap) {
        for (Map.Entry<SocketSinkImporter, BlockingQueue<Record>> entry : incrementalRecordMap.entrySet()) {
            Record record = (Record)entry.getValue().poll();
            if (!(record instanceof DataRecord)) continue;
            CDCDataRecordUtil.saveAckPosition(cdcAckPositionMap, entry.getKey(), record);
            return (DataRecord)record;
        }
        return null;
    }

    private static void saveAckPosition(Map<SocketSinkImporter, CDCAckPosition> cdcAckPositionMap, SocketSinkImporter socketSinkImporter, Record record) {
        CDCAckPosition cdcAckPosition = cdcAckPositionMap.get((Object)socketSinkImporter);
        if (null == cdcAckPosition) {
            cdcAckPositionMap.put(socketSinkImporter, new CDCAckPosition(record, 1));
        } else {
            cdcAckPosition.setLastRecord(record);
            cdcAckPosition.addDataRecordCount(cdcAckPosition.getDataRecordCount());
        }
    }

    private static DataRecord findMinimumDataRecordWithComparator(Map<SocketSinkImporter, BlockingQueue<Record>> incrementalRecordMap, Map<SocketSinkImporter, CDCAckPosition> cdcAckPositionMap, Comparator<DataRecord> dataRecordComparator) {
        HashMap<SocketSinkImporter, DataRecord> waitSortedMap = new HashMap<SocketSinkImporter, DataRecord>();
        for (Map.Entry<SocketSinkImporter, BlockingQueue<Record>> entry : incrementalRecordMap.entrySet()) {
            Record peek = (Record)entry.getValue().peek();
            if (null == peek || !(peek instanceof DataRecord)) continue;
            waitSortedMap.put(entry.getKey(), (DataRecord)peek);
        }
        if (waitSortedMap.isEmpty()) {
            return null;
        }
        DataRecord minRecord = null;
        SocketSinkImporter belongImporter = null;
        for (Map.Entry entry : waitSortedMap.entrySet()) {
            if (null == minRecord) {
                minRecord = (DataRecord)entry.getValue();
                belongImporter = (SocketSinkImporter)((Object)entry.getKey());
                continue;
            }
            if (dataRecordComparator.compare(minRecord, (DataRecord)entry.getValue()) <= 0) continue;
            minRecord = (DataRecord)entry.getValue();
            belongImporter = (SocketSinkImporter)((Object)entry.getKey());
        }
        if (null == minRecord) {
            return null;
        }
        incrementalRecordMap.get((Object)belongImporter).poll();
        CDCDataRecordUtil.saveAckPosition(cdcAckPositionMap, belongImporter, (Record)minRecord);
        return minRecord;
    }
}

