/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.job;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.cdc.api.impl.CDCJobAPI;
import org.apache.shardingsphere.data.pipeline.cdc.config.job.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.task.CDCTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCProcessContext;
import org.apache.shardingsphere.data.pipeline.cdc.context.job.CDCJobItemContext;
import org.apache.shardingsphere.data.pipeline.cdc.core.prepare.CDCJobPreparer;
import org.apache.shardingsphere.data.pipeline.cdc.core.task.CDCTasksRunner;
import org.apache.shardingsphere.data.pipeline.cdc.yaml.job.YamlCDCJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.DefaultPipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.job.AbstractSimplePipelineJob;
import org.apache.shardingsphere.data.pipeline.core.util.CloseUtil;
import org.apache.shardingsphere.data.pipeline.spi.importer.connector.ImporterConnector;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJob
extends AbstractSimplePipelineJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJob.class);
    private final ImporterConnector importerConnector;
    private final CDCJobAPI jobAPI = new CDCJobAPI();
    private final CDCJobPreparer jobPreparer = new CDCJobPreparer();
    private final PipelineDataSourceManager dataSourceManager = new DefaultPipelineDataSourceManager();

    protected void doPrepare(PipelineJobItemContext jobItemContext) {
        this.jobPreparer.initTasks((CDCJobItemContext)jobItemContext);
    }

    protected PipelineJobItemContext buildPipelineJobItemContext(ShardingContext shardingContext) {
        int shardingItem = shardingContext.getShardingItem();
        CDCJobConfiguration jobConfig = new YamlCDCJobConfigurationSwapper().swapToObject(shardingContext.getJobParameter());
        Optional initProgress = this.jobAPI.getJobItemProgress(shardingContext.getJobName(), shardingItem);
        CDCProcessContext jobProcessContext = this.jobAPI.buildPipelineProcessContext(jobConfig);
        CDCTaskConfiguration taskConfig = this.jobAPI.buildTaskConfiguration(jobConfig, shardingItem, jobProcessContext.getPipelineProcessConfig());
        return new CDCJobItemContext(jobConfig, shardingItem, initProgress.orElse(null), jobProcessContext, taskConfig, this.dataSourceManager, this.importerConnector);
    }

    protected PipelineTasksRunner buildPipelineTasksRunner(PipelineJobItemContext pipelineJobItemContext) {
        InventoryIncrementalJobItemContext jobItemContext = (InventoryIncrementalJobItemContext)pipelineJobItemContext;
        return new CDCTasksRunner((PipelineJobItemContext)jobItemContext, jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks());
    }

    protected void doClean() {
        this.dataSourceManager.close();
        if (this.importerConnector instanceof AutoCloseable) {
            CloseUtil.closeQuietly((AutoCloseable)((AutoCloseable)this.importerConnector));
        }
    }

    @Generated
    public CDCJob(ImporterConnector importerConnector) {
        this.importerConnector = importerConnector;
    }
}

