/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.importer;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.importer.Importer;
import org.apache.shardingsphere.data.pipeline.api.importer.ImporterType;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.PlaceholderRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.api.job.JobOperationType;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressUpdatedParameter;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckHolder;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckPosition;
import org.apache.shardingsphere.data.pipeline.cdc.core.connector.SocketSinkImporterConnector;
import org.apache.shardingsphere.data.pipeline.spi.importer.connector.ImporterConnector;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketSinkImporter
extends AbstractLifecycleExecutor
implements Importer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketSinkImporter.class);
    private final ImporterConfiguration importerConfig;
    private final PipelineChannel channel;
    private final SocketSinkImporterConnector importerConnector;
    private final PipelineJobProgressListener jobProgressListener;
    private final ImporterType importerType;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;

    public SocketSinkImporter(ImporterConfiguration importerConfig, ImporterConnector importerConnector, PipelineChannel channel, PipelineJobProgressListener jobProgressListener, ImporterType importerType) {
        this.importerConfig = importerConfig;
        this.rateLimitAlgorithm = null == importerConfig ? null : importerConfig.getRateLimitAlgorithm();
        this.channel = channel;
        this.importerConnector = (SocketSinkImporterConnector)importerConnector;
        this.jobProgressListener = jobProgressListener;
        this.importerType = importerType;
    }

    protected void runBlocking() {
        int batchSize = this.importerConfig.getBatchSize();
        if (ImporterType.INCREMENTAL == this.importerType) {
            this.importerConnector.sendIncrementalStartEvent(this, batchSize);
        }
        while (this.isRunning()) {
            List records = this.channel.fetchRecords(batchSize, 3);
            if (null == records || records.isEmpty()) continue;
            List<Record> recordList = records.stream().filter(each -> !(each instanceof PlaceholderRecord)).collect(Collectors.toList());
            try {
                this.processDataRecords(recordList);
            }
            catch (SQLException ex) {
                log.error("process data records failed", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            if (!FinishedRecord.class.equals(((Record)records.get(records.size() - 1)).getClass())) continue;
            break;
        }
    }

    private void processDataRecords(List<Record> recordList) throws SQLException {
        if (null == recordList || recordList.isEmpty()) {
            return;
        }
        if (null != this.rateLimitAlgorithm) {
            this.rateLimitAlgorithm.intercept(JobOperationType.INSERT, (Number)1);
        }
        this.importerConnector.write(recordList, this, this.importerType);
    }

    public void ackWithLastDataRecord(CDCAckPosition cdcAckPosition) {
        this.channel.ack(Collections.singletonList(cdcAckPosition.getLastRecord()));
        this.jobProgressListener.onProgressUpdated(new PipelineJobProgressUpdatedParameter(cdcAckPosition.getDataRecordCount()));
    }

    protected void doStop() {
        if (ImporterType.INCREMENTAL == this.importerType) {
            this.importerConnector.clean(this);
            CDCAckHolder.getInstance().cleanUp(this);
        }
    }

    @Generated
    protected ImporterConfiguration getImporterConfig() {
        return this.importerConfig;
    }

    @Generated
    public ImporterType getImporterType() {
        return this.importerType;
    }
}

