/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.ack;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;

public final class CDCAckPosition {
    private Record lastRecord;
    private final AtomicInteger dataRecordCount = new AtomicInteger();
    private final long createTimeMills;

    public CDCAckPosition(Record lastRecord, int dataRecordCount) {
        this.lastRecord = lastRecord;
        this.dataRecordCount.set(dataRecordCount);
        this.createTimeMills = System.currentTimeMillis();
    }

    public CDCAckPosition(Record lastRecord, long createTimeMills) {
        this.lastRecord = lastRecord;
        this.createTimeMills = createTimeMills;
    }

    public void addDataRecordCount(int count) {
        this.dataRecordCount.addAndGet(count);
    }

    public int getDataRecordCount() {
        return this.dataRecordCount.get();
    }

    @Generated
    public Record getLastRecord() {
        return this.lastRecord;
    }

    @Generated
    public long getCreateTimeMills() {
        return this.createTimeMills;
    }

    @Generated
    public void setLastRecord(Record lastRecord) {
        this.lastRecord = lastRecord;
    }
}

