/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.ack;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.core.ack.CDCAckPosition;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.SocketSinkImporter;

public final class CDCAckHolder {
    private static final CDCAckHolder INSTANCE = new CDCAckHolder();
    private final Map<String, Map<SocketSinkImporter, CDCAckPosition>> ackIdPositionMap = new ConcurrentHashMap<String, Map<SocketSinkImporter, CDCAckPosition>>();

    public void ack(String ackId) {
        Map<SocketSinkImporter, CDCAckPosition> importerDataRecordMap = this.ackIdPositionMap.remove(ackId);
        if (null != importerDataRecordMap) {
            importerDataRecordMap.forEach(SocketSinkImporter::ackWithLastDataRecord);
        }
    }

    public String bindAckIdWithPosition(Map<SocketSinkImporter, CDCAckPosition> importerDataRecordMap) {
        String result = this.generateAckId();
        this.ackIdPositionMap.put(result, importerDataRecordMap);
        return result;
    }

    private String generateAckId() {
        return "ACK-" + UUID.randomUUID();
    }

    public void cleanUp(SocketSinkImporter socketSinkImporter) {
        if (this.ackIdPositionMap.isEmpty()) {
            return;
        }
        this.ackIdPositionMap.entrySet().removeIf(entry -> ((Map)entry.getValue()).containsKey((Object)socketSinkImporter));
    }

    public static CDCAckHolder getInstance() {
        return INSTANCE;
    }

    @Generated
    private CDCAckHolder() {
    }
}

