/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.context.job;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressUpdatedParameter;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.cdc.config.job.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.task.CDCTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCProcessContext;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.spi.importer.connector.ImporterConnector;

public final class CDCJobItemContext
implements InventoryIncrementalJobItemContext {
    private final CDCJobConfiguration jobConfig;
    private final int shardingItem;
    private volatile boolean stopping;
    private volatile JobStatus status = JobStatus.RUNNING;
    private final InventoryIncrementalJobItemProgress initProgress;
    private final CDCProcessContext jobProcessContext;
    private final CDCTaskConfiguration taskConfig;
    private final PipelineDataSourceManager dataSourceManager;
    private final ImporterConnector importerConnector;
    private final Collection<InventoryTask> inventoryTasks = new LinkedList<InventoryTask>();
    private final Collection<IncrementalTask> incrementalTasks = new LinkedList<IncrementalTask>();
    private final AtomicLong processedRecordsCount = new AtomicLong(0L);
    private final AtomicLong inventoryRecordsCount = new AtomicLong(0L);
    private final LazyInitializer<PipelineDataSourceWrapper> sourceDataSourceLazyInitializer = new LazyInitializer<PipelineDataSourceWrapper>(){

        protected PipelineDataSourceWrapper initialize() {
            return CDCJobItemContext.this.dataSourceManager.getDataSource(CDCJobItemContext.this.taskConfig.getDumperConfig().getDataSourceConfig());
        }
    };
    private final LazyInitializer<PipelineTableMetaDataLoader> sourceMetaDataLoaderLazyInitializer = new LazyInitializer<PipelineTableMetaDataLoader>(){

        protected PipelineTableMetaDataLoader initialize() throws ConcurrentException {
            return new StandardPipelineTableMetaDataLoader((PipelineDataSourceWrapper)CDCJobItemContext.this.sourceDataSourceLazyInitializer.get());
        }
    };

    public CDCJobItemContext(CDCJobConfiguration jobConfig, int shardingItem, InventoryIncrementalJobItemProgress initProgress, CDCProcessContext jobProcessContext, CDCTaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager, ImporterConnector importerConnector) {
        this.jobConfig = jobConfig;
        this.shardingItem = shardingItem;
        this.initProgress = initProgress;
        this.jobProcessContext = jobProcessContext;
        this.taskConfig = taskConfig;
        this.dataSourceManager = dataSourceManager;
        this.importerConnector = importerConnector;
    }

    public String getJobId() {
        return this.jobConfig.getJobId();
    }

    public String getDataSourceName() {
        return this.taskConfig.getDumperConfig().getDataSourceName();
    }

    public void onProgressUpdated(PipelineJobProgressUpdatedParameter param) {
        this.processedRecordsCount.addAndGet(param.getProcessedRecordsCount());
        PipelineJobProgressPersistService.notifyPersist((String)this.jobConfig.getJobId(), (int)this.shardingItem);
    }

    public PipelineDataSourceWrapper getSourceDataSource() {
        return (PipelineDataSourceWrapper)this.sourceDataSourceLazyInitializer.get();
    }

    public PipelineTableMetaDataLoader getSourceMetaDataLoader() {
        return (PipelineTableMetaDataLoader)this.sourceMetaDataLoaderLazyInitializer.get();
    }

    public ImporterConnector getImporterConnector() {
        return this.importerConnector;
    }

    public long getProcessedRecordsCount() {
        return this.processedRecordsCount.get();
    }

    public void updateInventoryRecordsCount(long recordsCount) {
        this.inventoryRecordsCount.addAndGet(recordsCount);
    }

    public long getInventoryRecordsCount() {
        return this.inventoryRecordsCount.get();
    }

    @Generated
    public CDCJobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public InventoryIncrementalJobItemProgress getInitProgress() {
        return this.initProgress;
    }

    @Generated
    public CDCProcessContext getJobProcessContext() {
        return this.jobProcessContext;
    }

    @Generated
    public CDCTaskConfiguration getTaskConfig() {
        return this.taskConfig;
    }

    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Generated
    public Collection<InventoryTask> getInventoryTasks() {
        return this.inventoryTasks;
    }

    @Generated
    public Collection<IncrementalTask> getIncrementalTasks() {
        return this.incrementalTasks;
    }

    @Generated
    public LazyInitializer<PipelineDataSourceWrapper> getSourceDataSourceLazyInitializer() {
        return this.sourceDataSourceLazyInitializer;
    }

    @Generated
    public LazyInitializer<PipelineTableMetaDataLoader> getSourceMetaDataLoaderLazyInitializer() {
        return this.sourceMetaDataLoaderLazyInitializer;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

