/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.api.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.ActualTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.pojo.PipelineJobMetaData;
import org.apache.shardingsphere.data.pipeline.api.pojo.TableBasedPipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.api.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.cdc.api.job.type.CDCJobType;
import org.apache.shardingsphere.data.pipeline.cdc.api.pojo.StreamDataParameter;
import org.apache.shardingsphere.data.pipeline.cdc.config.job.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.task.CDCTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.constant.CDCSinkType;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCProcessContext;
import org.apache.shardingsphere.data.pipeline.cdc.core.job.CDCJob;
import org.apache.shardingsphere.data.pipeline.cdc.core.job.CDCJobId;
import org.apache.shardingsphere.data.pipeline.cdc.yaml.job.YamlCDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.yaml.job.YamlCDCJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.impl.AbstractInventoryIncrementalJobAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.DefaultPipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobCreationWithInvalidShardingCountException;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.prepare.PipelineJobPreparerUtils;
import org.apache.shardingsphere.data.pipeline.core.sharding.ShardingColumnsExtractor;
import org.apache.shardingsphere.data.pipeline.core.util.JobDataNodeLineConvertUtil;
import org.apache.shardingsphere.data.pipeline.spi.job.JobType;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJobAPI
extends AbstractInventoryIncrementalJobAPIImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJobAPI.class);
    private final YamlDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlDataSourceConfigurationSwapper();
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlPipelineDataSourceConfigurationSwapper pipelineDataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();

    public String createJob(StreamDataParameter param, CDCSinkType sinkType, Properties sinkProps) {
        YamlCDCJobConfiguration yamlJobConfig = new YamlCDCJobConfiguration();
        yamlJobConfig.setDatabaseName(param.getDatabaseName());
        yamlJobConfig.setSchemaTableNames(param.getSchemaTableNames());
        yamlJobConfig.setFull(param.isFull());
        yamlJobConfig.setDecodeWithTX(param.isDecodeWithTX());
        YamlCDCJobConfiguration.YamlSinkConfiguration sinkConfig = new YamlCDCJobConfiguration.YamlSinkConfiguration();
        sinkConfig.setSinkType(sinkType.name());
        sinkConfig.setProps(sinkProps);
        yamlJobConfig.setSinkConfig(sinkConfig);
        ShardingSphereDatabase database = PipelineContext.getContextManager().getMetaDataContexts().getMetaData().getDatabase(param.getDatabaseName());
        yamlJobConfig.setDataSourceConfiguration(this.pipelineDataSourceConfigSwapper.swapToYamlConfiguration((PipelineDataSourceConfiguration)this.getDataSourceConfiguration(database)));
        List jobDataNodeLines = JobDataNodeLineConvertUtil.convertDataNodesToLines(param.getDataNodesMap());
        yamlJobConfig.setJobShardingDataNodes(jobDataNodeLines.stream().map(JobDataNodeLine::marshal).collect(Collectors.toList()));
        JobDataNodeLine tableFirstDataNodes = new JobDataNodeLine(param.getDataNodesMap().entrySet().stream().map(each -> new JobDataNodeEntry((String)each.getKey(), ((List)each.getValue()).subList(0, 1))).collect(Collectors.toList()));
        yamlJobConfig.setTablesFirstDataNodes(tableFirstDataNodes.marshal());
        this.extendYamlJobConfiguration(yamlJobConfig);
        CDCJobConfiguration jobConfig = new YamlCDCJobConfigurationSwapper().swapToObject(yamlJobConfig);
        ShardingSpherePreconditions.checkState((0 != jobConfig.getJobShardingCount() ? 1 : 0) != 0, () -> new PipelineJobCreationWithInvalidShardingCountException(jobConfig.getJobId()));
        GovernanceRepositoryAPI repositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
        String jobConfigKey = PipelineMetaDataNode.getJobConfigPath((String)jobConfig.getJobId());
        if (repositoryAPI.isExisted(jobConfigKey)) {
            log.warn("CDC job already exists in registry center, ignore, jobConfigKey={}", (Object)jobConfigKey);
            return jobConfig.getJobId();
        }
        repositoryAPI.persist(PipelineMetaDataNode.getJobRootPath((String)jobConfig.getJobId()), this.getJobClassName());
        JobConfigurationPOJO jobConfigPOJO = this.convertJobConfiguration(jobConfig);
        jobConfigPOJO.setDisabled(true);
        repositoryAPI.persist(jobConfigKey, YamlEngine.marshal((Object)jobConfigPOJO));
        if (!param.isFull()) {
            this.initIncrementalPosition(jobConfig);
        }
        return jobConfig.getJobId();
    }

    private void initIncrementalPosition(CDCJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        try (DefaultPipelineDataSourceManager dataSourceManager = new DefaultPipelineDataSourceManager();){
            for (int i = 0; i < jobConfig.getJobShardingCount(); ++i) {
                if (this.getJobItemProgress(jobId, i).isPresent()) continue;
                TableNameSchemaNameMapping tableNameSchemaNameMapping = this.getTableNameSchemaNameMapping(jobConfig.getSchemaTableNames());
                DumperConfiguration dumperConfig = CDCJobAPI.buildDumperConfiguration(jobConfig, i, tableNameSchemaNameMapping);
                InventoryIncrementalJobItemProgress jobItemProgress = new InventoryIncrementalJobItemProgress();
                jobItemProgress.setSourceDatabaseType(jobConfig.getSourceDatabaseType());
                jobItemProgress.setDataSourceName(dumperConfig.getDataSourceName());
                IncrementalTaskProgress incrementalTaskProgress = new IncrementalTaskProgress();
                incrementalTaskProgress.setPosition(PipelineJobPreparerUtils.getIncrementalPosition(null, (DumperConfiguration)dumperConfig, (PipelineDataSourceManager)dataSourceManager));
                jobItemProgress.setIncremental(new JobItemIncrementalTasksProgress(incrementalTaskProgress));
                PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobItemProgress(jobId, i, YamlEngine.marshal((Object)this.getJobItemProgressSwapper().swapToYamlConfiguration(jobItemProgress)));
            }
        }
    }

    private ShardingSpherePipelineDataSourceConfiguration getDataSourceConfiguration(ShardingSphereDatabase database) {
        HashMap<String, Map> dataSourceProps = new HashMap<String, Map>();
        for (Map.Entry entry : database.getResourceMetaData().getDataSources().entrySet()) {
            dataSourceProps.put((String)entry.getKey(), this.dataSourceConfigSwapper.swapToMap(DataSourcePropertiesCreator.create((DataSource)((DataSource)entry.getValue()))));
        }
        YamlRootConfiguration targetRootConfig = new YamlRootConfiguration();
        targetRootConfig.setDatabaseName(database.getName());
        targetRootConfig.setDataSources(dataSourceProps);
        Collection yamlRuleConfigurations = this.ruleConfigSwapperEngine.swapToYamlRuleConfigurations(database.getRuleMetaData().getConfigurations());
        targetRootConfig.setRules(yamlRuleConfigurations);
        return new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
    }

    public void extendYamlJobConfiguration(YamlPipelineJobConfiguration yamlJobConfig) {
        YamlCDCJobConfiguration config = (YamlCDCJobConfiguration)yamlJobConfig;
        if (null == yamlJobConfig.getJobId()) {
            config.setJobId(this.generateJobId(config));
        }
        if (Strings.isNullOrEmpty((String)config.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)config.getDataSourceConfiguration().getType(), (String)config.getDataSourceConfiguration().getParameter());
            config.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getType());
        }
    }

    private String generateJobId(YamlCDCJobConfiguration config) {
        CDCJobId jobId = new CDCJobId(config.getDatabaseName(), config.getSchemaTableNames(), config.isFull());
        return this.marshalJobId((PipelineJobId)jobId);
    }

    protected String marshalJobIdLeftPart(PipelineJobId pipelineJobId) {
        CDCJobId jobId = (CDCJobId)pipelineJobId;
        String text = Joiner.on((char)'|').join((Object)jobId.getDatabaseName(), jobId.getSchemaTableNames(), new Object[]{jobId.isFull()});
        return DigestUtils.md5Hex((byte[])text.getBytes(StandardCharsets.UTF_8));
    }

    public CDCTaskConfiguration buildTaskConfiguration(PipelineJobConfiguration pipelineJobConfig, int jobShardingItem, PipelineProcessConfiguration pipelineProcessConfig) {
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)pipelineJobConfig;
        TableNameSchemaNameMapping tableNameSchemaNameMapping = this.getTableNameSchemaNameMapping(jobConfig.getSchemaTableNames());
        DumperConfiguration dumperConfig = CDCJobAPI.buildDumperConfiguration(jobConfig, jobShardingItem, tableNameSchemaNameMapping);
        ImporterConfiguration importerConfig = this.buildImporterConfiguration(jobConfig, pipelineProcessConfig, jobConfig.getSchemaTableNames(), tableNameSchemaNameMapping);
        CDCTaskConfiguration result = new CDCTaskConfiguration(dumperConfig, importerConfig);
        log.debug("buildTaskConfiguration, result={}", (Object)result);
        return result;
    }

    private TableNameSchemaNameMapping getTableNameSchemaNameMapping(Collection<String> tableNames) {
        LinkedHashMap<String, String> tableNameSchemaMap = new LinkedHashMap<String, String>();
        for (String each : tableNames) {
            String[] split = each.split("\\.");
            if (split.length <= 1) continue;
            tableNameSchemaMap.put(split[1], split[0]);
        }
        return new TableNameSchemaNameMapping(tableNameSchemaMap);
    }

    private static DumperConfiguration buildDumperConfiguration(CDCJobConfiguration jobConfig, int jobShardingItem, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        JobDataNodeLine dataNodeLine = jobConfig.getJobShardingDataNodes().get(jobShardingItem);
        LinkedHashMap tableNameMap = new LinkedHashMap();
        dataNodeLine.getEntries().forEach(each -> each.getDataNodes().forEach(node -> tableNameMap.put(new ActualTableName(node.getTableName()), new LogicTableName(each.getLogicTableName()))));
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().iterator().next()).getDataNodes().iterator().next()).getDataSourceName();
        StandardPipelineDataSourceConfiguration actualDataSourceConfig = jobConfig.getDataSourceConfig().getActualDataSourceConfiguration(dataSourceName);
        DumperConfiguration result = new DumperConfiguration();
        result.setJobId(jobConfig.getJobId());
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig((PipelineDataSourceConfiguration)actualDataSourceConfig);
        result.setTableNameMap(tableNameMap);
        result.setTableNameSchemaNameMapping(tableNameSchemaNameMapping);
        result.setDecodeWithTX(jobConfig.isDecodeWithTX());
        return result;
    }

    private ImporterConfiguration buildImporterConfiguration(CDCJobConfiguration jobConfig, PipelineProcessConfiguration pipelineProcessConfig, Collection<String> schemaTableNames, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        PipelineDataSourceConfiguration dataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getDataSourceConfig().getType(), (String)jobConfig.getDataSourceConfig().getParameter());
        CDCProcessContext processContext = new CDCProcessContext(jobConfig.getJobId(), pipelineProcessConfig);
        JobRateLimitAlgorithm writeRateLimitAlgorithm = processContext.getWriteRateLimitAlgorithm();
        int batchSize = pipelineProcessConfig.getWrite().getBatchSize();
        Map shardingColumnsMap = new ShardingColumnsExtractor().getShardingColumnsMap(jobConfig.getDataSourceConfig().getRootConfig().getRules(), schemaTableNames.stream().map(LogicTableName::new).collect(Collectors.toSet()));
        return new ImporterConfiguration(dataSourceConfig, shardingColumnsMap, tableNameSchemaNameMapping, batchSize, writeRateLimitAlgorithm, 0, 1);
    }

    public CDCProcessContext buildPipelineProcessContext(PipelineJobConfiguration pipelineJobConfig) {
        return new CDCProcessContext(pipelineJobConfig.getJobId(), this.showProcessConfiguration());
    }

    public CDCJobConfiguration getJobConfiguration(String jobId) {
        return this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
    }

    protected CDCJobConfiguration getJobConfiguration(JobConfigurationPOJO jobConfigPOJO) {
        return new YamlCDCJobConfigurationSwapper().swapToObject(jobConfigPOJO.getJobParameter());
    }

    protected YamlPipelineJobConfiguration swapToYamlJobConfiguration(PipelineJobConfiguration jobConfig) {
        return new YamlCDCJobConfigurationSwapper().swapToYamlConfiguration((CDCJobConfiguration)jobConfig);
    }

    protected TableBasedPipelineJobInfo getJobInfo(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        PipelineJobMetaData jobMetaData = this.buildPipelineJobMetaData(jobConfigPOJO);
        CDCJobConfiguration jobConfig = this.getJobConfiguration(jobConfigPOJO);
        return new TableBasedPipelineJobInfo(jobMetaData, jobConfig.getDatabaseName(), String.join((CharSequence)", ", jobConfig.getSchemaTableNames()));
    }

    public void rollback(String jobId) throws SQLException {
        this.stop(jobId);
        this.dropJob(jobId);
    }

    public void commit(String jobId) {
        throw new UnsupportedOperationException();
    }

    protected PipelineDataConsistencyChecker buildPipelineDataConsistencyChecker(PipelineJobConfiguration pipelineJobConfig, InventoryIncrementalProcessContext processContext, ConsistencyCheckJobItemProgressContext progressContext) {
        throw new UnsupportedOperationException();
    }

    protected String getTargetDatabaseType(PipelineJobConfiguration pipelineJobConfig) {
        throw new UnsupportedOperationException();
    }

    protected String getJobClassName() {
        return CDCJob.class.getName();
    }

    public JobType getJobType() {
        return new CDCJobType();
    }
}

