/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.ui.servcie;

import com.google.common.base.Optional;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfig;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfigs;

/**
 * Registry center config service.
 *
 * @author chenqingyang
 */
public interface RegistryCenterConfigService {
    
    /**
     * Load registry center config.
     *
     * @param name registry center config name
     * @return registry center config
     */
    RegistryCenterConfig load(String name);
    
    /**
     * Load the activated registry center config.
     *
     * @return activated registry center config
     */
    Optional<RegistryCenterConfig> loadActivated();
    
    /**
     * Add registry center config.
     *
     * @param config registry center config
     */
    void add(RegistryCenterConfig config);
    
    /**
     * Delete registry center config.
     *
     * @param name registry center config name
     */
    void delete(String name);
    
    /**
     * Set activated registry center config.
     *
     * @param name registry center config name
     */
    void setActivated(String name);
    
    /**
     * Load all registry center configs.
     *
     * @return all registry center configs.
     */
    RegistryCenterConfigs loadAll();
}
