/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import com.google.common.base.Preconditions;
import io.seata.config.FileConfiguration;
import io.seata.core.context.RootContext;
import io.seata.core.rpc.netty.RmRpcClient;
import io.seata.core.rpc.netty.TmRpcClient;
import io.seata.rm.RMClient;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.tm.TMClient;
import io.seata.tm.api.GlobalTransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.apache.shardingsphere.transaction.base.seata.at.SeataTransactionBroadcaster;
import org.apache.shardingsphere.transaction.base.seata.at.SeataTransactionHolder;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;

public final class SeataATShardingTransactionManager
implements ShardingTransactionManager {
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final FileConfiguration configuration = new FileConfiguration("seata.conf");

    public void init(DatabaseType databaseType, Collection<ResourceDataSource> resourceDataSources) {
        this.initSeataRPCClient();
        for (ResourceDataSource each : resourceDataSources) {
            this.dataSourceMap.put(each.getOriginalName(), (DataSource)new DataSourceProxy(each.getDataSource()));
        }
    }

    public TransactionType getTransactionType() {
        return TransactionType.BASE;
    }

    public boolean isInTransaction() {
        return null != RootContext.getXID();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        return this.dataSourceMap.get(dataSourceName).getConnection();
    }

    public void begin() {
        SeataTransactionHolder.set(GlobalTransactionContext.getCurrentOrCreate());
        SeataTransactionHolder.get().begin();
        SeataTransactionBroadcaster.collectGlobalTxId();
    }

    public void commit() {
        try {
            SeataTransactionHolder.get().commit();
        }
        finally {
            SeataTransactionBroadcaster.clear();
            SeataTransactionHolder.clear();
        }
    }

    public void rollback() {
        try {
            SeataTransactionHolder.get().rollback();
        }
        finally {
            SeataTransactionBroadcaster.clear();
            SeataTransactionHolder.clear();
        }
    }

    public void close() {
        this.dataSourceMap.clear();
        SeataTransactionHolder.clear();
        TmRpcClient.getInstance().destroy();
        RmRpcClient.getInstance().destroy();
    }

    private void initSeataRPCClient() {
        String applicationId = this.configuration.getConfig("client.application.id");
        Preconditions.checkNotNull((Object)applicationId, (Object)"please config application id within seata.conf file");
        String transactionServiceGroup = this.configuration.getConfig("client.transaction.service.group", "default");
        TMClient.init((String)applicationId, (String)transactionServiceGroup);
        RMClient.init((String)applicationId, (String)transactionServiceGroup);
    }
}

