/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.text;

import com.google.common.base.Optional;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.database.DatabaseTypes;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.shardingproxy.frontend.api.QueryCommandExecutor;
import org.apache.shardingsphere.shardingproxy.transport.packet.DatabasePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.text.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.text.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.generic.PostgreSQLErrorResponsePacket;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class PostgreSQLComQueryExecutor
implements QueryCommandExecutor {
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private volatile boolean isQuery;

    public PostgreSQLComQueryExecutor(PostgreSQLComQueryPacket comQueryPacket, BackendConnection backendConnection) {
        this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypes.getActualDatabaseType((String)"PostgreSQL"), (String)comQueryPacket.getSql(), (BackendConnection)backendConnection);
    }

    public Collection<DatabasePacket> execute() {
        if (ShardingProxyContext.getInstance().isCircuitBreak()) {
            return Collections.singletonList(new PostgreSQLErrorResponsePacket());
        }
        BackendResponse backendResponse = this.textProtocolBackendHandler.execute();
        if (backendResponse instanceof ErrorResponse) {
            return Collections.singletonList(this.createErrorPacket((ErrorResponse)backendResponse));
        }
        if (backendResponse instanceof UpdateResponse) {
            return Collections.singletonList(this.createUpdatePacket((UpdateResponse)backendResponse));
        }
        Optional<PostgreSQLRowDescriptionPacket> result = this.createQueryPacket((QueryResponse)backendResponse);
        return result.isPresent() ? Collections.singletonList(result.get()) : Collections.emptyList();
    }

    private PostgreSQLErrorResponsePacket createErrorPacket(ErrorResponse errorResponse) {
        return new PostgreSQLErrorResponsePacket();
    }

    private PostgreSQLCommandCompletePacket createUpdatePacket(UpdateResponse updateResponse) {
        return new PostgreSQLCommandCompletePacket();
    }

    private Optional<PostgreSQLRowDescriptionPacket> createQueryPacket(QueryResponse queryResponse) {
        List<PostgreSQLColumnDescription> columnDescriptions = this.getPostgreSQLColumnDescriptions(queryResponse);
        boolean bl = this.isQuery = !columnDescriptions.isEmpty();
        if (columnDescriptions.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions));
    }

    private List<PostgreSQLColumnDescription> getPostgreSQLColumnDescriptions(QueryResponse queryResponse) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponse.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnName(), ++columnIndex, each.getColumnType().intValue(), each.getColumnLength()));
        }
        return result;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public boolean next() throws SQLException {
        return this.textProtocolBackendHandler.next();
    }

    public PostgreSQLPacket getQueryData() throws SQLException {
        return new PostgreSQLDataRowPacket(this.textProtocolBackendHandler.getQueryData().getData());
    }
}

