/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.parse;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.frontend.api.CommandExecutor;
import org.apache.shardingsphere.shardingproxy.transport.packet.DatabasePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.BinaryStatementRegistry;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.ConnectionScopeBinaryStatementRegistry;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.parse.PostgreSQLParseCompletePacket;

public final class PostgreSQLComParseExecutor
implements CommandExecutor {
    private final PostgreSQLComParsePacket packet;
    private final LogicSchema logicSchema;
    private final ConnectionScopeBinaryStatementRegistry binaryStatementRegistry;

    public PostgreSQLComParseExecutor(PostgreSQLComParsePacket packet, BackendConnection backendConnection) {
        this.packet = packet;
        this.logicSchema = backendConnection.getLogicSchema();
        this.binaryStatementRegistry = BinaryStatementRegistry.getInstance().get(backendConnection.getConnectionId());
    }

    public Collection<DatabasePacket> execute() {
        if (!this.packet.getSql().isEmpty()) {
            SQLStatement sqlStatement = this.logicSchema.getParseEngine().parse(this.packet.getSql(), true);
            this.binaryStatementRegistry.register(this.packet.getStatementId(), this.packet.getSql(), sqlStatement.getParametersCount(), this.packet.getBinaryStatementParameterTypes());
        }
        return Collections.singletonList(new PostgreSQLParseCompletePacket());
    }
}

