/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.bind;

import com.google.common.base.Optional;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.shardingproxy.frontend.api.QueryCommandExecutor;
import org.apache.shardingsphere.shardingproxy.transport.packet.DatabasePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.constant.PostgreSQLColumnType;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.bind.PostgreSQLBinaryResultSetRowPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.bind.PostgreSQLBindCompletePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.text.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.generic.PostgreSQLErrorResponsePacket;

public final class PostgreSQLComBindExecutor
implements QueryCommandExecutor {
    private final PostgreSQLComBindPacket packet;
    private final DatabaseCommunicationEngine databaseCommunicationEngine;
    private volatile boolean isQuery;

    public PostgreSQLComBindExecutor(PostgreSQLComBindPacket packet, BackendConnection backendConnection) {
        this.packet = packet;
        this.databaseCommunicationEngine = null == packet.getSql() ? null : DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(backendConnection.getLogicSchema(), packet.getSql(), packet.getParameters(), backendConnection);
    }

    public Collection<DatabasePacket> execute() {
        Optional<PostgreSQLRowDescriptionPacket> postgreSQLRowDescriptionPacket;
        if (ShardingProxyContext.getInstance().isCircuitBreak()) {
            return Collections.singletonList(new PostgreSQLErrorResponsePacket());
        }
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        result.add((DatabasePacket)new PostgreSQLBindCompletePacket());
        if (null == this.databaseCommunicationEngine) {
            return result;
        }
        BackendResponse backendResponse = this.databaseCommunicationEngine.execute();
        if (backendResponse instanceof ErrorResponse) {
            result.add((DatabasePacket)this.createErrorPacket((ErrorResponse)backendResponse));
        }
        if (backendResponse instanceof UpdateResponse) {
            result.add((DatabasePacket)this.createUpdatePacket((UpdateResponse)backendResponse));
        }
        if (backendResponse instanceof QueryResponse && (postgreSQLRowDescriptionPacket = this.createQueryPacket((QueryResponse)backendResponse)).isPresent()) {
            result.add((DatabasePacket)postgreSQLRowDescriptionPacket.get());
        }
        return result;
    }

    private PostgreSQLErrorResponsePacket createErrorPacket(ErrorResponse errorResponse) {
        return new PostgreSQLErrorResponsePacket();
    }

    private PostgreSQLCommandCompletePacket createUpdatePacket(UpdateResponse updateResponse) {
        return new PostgreSQLCommandCompletePacket();
    }

    private Optional<PostgreSQLRowDescriptionPacket> createQueryPacket(QueryResponse queryResponse) {
        List<PostgreSQLColumnDescription> columnDescriptions = this.getPostgreSQLColumnDescriptions(queryResponse);
        boolean bl = this.isQuery = !columnDescriptions.isEmpty();
        if (columnDescriptions.isEmpty() || this.packet.isBinaryRowData()) {
            return Optional.absent();
        }
        return Optional.of((Object)new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions));
    }

    private List<PostgreSQLColumnDescription> getPostgreSQLColumnDescriptions(QueryResponse queryResponse) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponse.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnName(), ++columnIndex, each.getColumnType().intValue(), each.getColumnLength()));
        }
        return result;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public boolean next() throws SQLException {
        return null != this.databaseCommunicationEngine && this.databaseCommunicationEngine.next();
    }

    public PostgreSQLPacket getQueryData() throws SQLException {
        QueryData queryData = this.databaseCommunicationEngine.getQueryData();
        return this.packet.isBinaryRowData() ? new PostgreSQLBinaryResultSetRowPacket(queryData.getData(), this.getPostgreSQLColumnTypes(queryData)) : new PostgreSQLDataRowPacket(queryData.getData());
    }

    private List<PostgreSQLColumnType> getPostgreSQLColumnTypes(QueryData queryData) {
        ArrayList<PostgreSQLColumnType> result = new ArrayList<PostgreSQLColumnType>(queryData.getColumnTypes().size());
        for (int i = 0; i < queryData.getColumnTypes().size(); ++i) {
            result.add(PostgreSQLColumnType.valueOfJDBCType((int)((Integer)queryData.getColumnTypes().get(i))));
        }
        return result;
    }
}

