/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql.command;

import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.frontend.api.CommandExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.generic.PostgreSQLComTerminationExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.generic.PostgreSQLUnsupportedCommandExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.bind.PostgreSQLComBindExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.describe.PostgreSQLComDescribeExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.execute.PostgreSQLComExecuteExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.parse.PostgreSQLComParseExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.binary.sync.PostgreSQLComSyncExecutor;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.query.text.PostgreSQLComQueryExecutor;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.text.PostgreSQLComQueryPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLCommandExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLCommandExecutorFactory.class);

    public static CommandExecutor newInstance(PostgreSQLCommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, BackendConnection backendConnection) {
        log.debug("Execute packet type: {}, value: {}", (Object)commandPacketType, (Object)commandPacket);
        switch (commandPacketType) {
            case QUERY: {
                return new PostgreSQLComQueryExecutor((PostgreSQLComQueryPacket)commandPacket, backendConnection);
            }
            case PARSE: {
                return new PostgreSQLComParseExecutor((PostgreSQLComParsePacket)commandPacket, backendConnection);
            }
            case BIND: {
                return new PostgreSQLComBindExecutor((PostgreSQLComBindPacket)commandPacket, backendConnection);
            }
            case DESCRIBE: {
                return new PostgreSQLComDescribeExecutor();
            }
            case EXECUTE: {
                return new PostgreSQLComExecuteExecutor();
            }
            case SYNC: {
                return new PostgreSQLComSyncExecutor();
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationExecutor();
            }
        }
        return new PostgreSQLUnsupportedCommandExecutor();
    }

    private PostgreSQLCommandExecutorFactory() {
    }
}

