/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql.auth;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.frontend.ConnectionIdGenerator;
import org.apache.shardingsphere.shardingproxy.frontend.engine.AuthenticationEngine;
import org.apache.shardingsphere.shardingproxy.transport.payload.PacketPayload;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.BinaryStatementRegistry;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.handshake.PostgreSQLAuthenticationOKPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.handshake.PostgreSQLComStartupPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.handshake.PostgreSQLSSLNegativePacket;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLAuthenticationEngine
implements AuthenticationEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private static final String DATABASE_NAME_KEYWORD = "database";

    public void handshake(ChannelHandlerContext context, BackendConnection backendConnection) {
        int connectionId = ConnectionIdGenerator.getInstance().nextId();
        backendConnection.setConnectionId(connectionId);
        BinaryStatementRegistry.getInstance().register(connectionId);
    }

    public boolean auth(ChannelHandlerContext context, PacketPayload payload, BackendConnection backendConnection) {
        if (8 == payload.getByteBuf().markReaderIndex().readInt() && 80877103 == payload.getByteBuf().readInt()) {
            context.writeAndFlush((Object)new PostgreSQLSSLNegativePacket());
            return false;
        }
        payload.getByteBuf().resetReaderIndex();
        PostgreSQLComStartupPacket comStartupPacket = new PostgreSQLComStartupPacket((PostgreSQLPacketPayload)payload);
        String databaseName = (String)comStartupPacket.getParametersMap().get(DATABASE_NAME_KEYWORD);
        if (!Strings.isNullOrEmpty((String)databaseName) && !LogicSchemas.getInstance().schemaExists(databaseName)) {
            return true;
        }
        backendConnection.setCurrentSchema(databaseName);
        context.write((Object)new PostgreSQLAuthenticationOKPacket(true));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_version", "8.4"));
        context.write((Object)new PostgreSQLParameterStatusPacket("client_encoding", "UTF8"));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_encoding", "UTF8"));
        context.writeAndFlush((Object)new PostgreSQLReadyForQueryPacket());
        return true;
    }
}

