/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.frontend.postgresql;

import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.frontend.context.FrontendContext;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.auth.PostgreSQLAuthenticationEngine;
import org.apache.shardingsphere.shardingproxy.frontend.postgresql.command.PostgreSQLCommandExecuteEngine;
import org.apache.shardingsphere.shardingproxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.shardingproxy.transport.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.codec.PostgreSQLPacketCodecEngine;
import org.apache.shardingsphere.shardingproxy.transport.postgresql.packet.command.query.binary.BinaryStatementRegistry;

public final class PostgreSQLProtocolFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final FrontendContext frontendContext = new FrontendContext(true, false);
    private final PostgreSQLAuthenticationEngine authEngine = new PostgreSQLAuthenticationEngine();
    private final PostgreSQLCommandExecuteEngine commandExecuteEngine = new PostgreSQLCommandExecuteEngine();
    private final DatabasePacketCodecEngine codecEngine = new PostgreSQLPacketCodecEngine();

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    public void release(BackendConnection backendConnection) {
        BinaryStatementRegistry.getInstance().unregister(backendConnection.getConnectionId());
    }

    public FrontendContext getFrontendContext() {
        return this.frontendContext;
    }

    public PostgreSQLAuthenticationEngine getAuthEngine() {
        return this.authEngine;
    }

    public PostgreSQLCommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    public DatabasePacketCodecEngine getCodecEngine() {
        return this.codecEngine;
    }
}

