/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.admin;

import java.beans.ConstructorProperties;
import java.util.Collection;
import org.apache.shardingsphere.core.rule.ProxyUser;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.dialect.mysql.UseStatement;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class UseDatabaseBackendHandler
implements TextProtocolBackendHandler {
    private final UseStatement useStatement;
    private final BackendConnection backendConnection;

    @Override
    public BackendResponse execute() {
        String schema = SQLUtil.getExactlyValue((String)this.useStatement.getSchema());
        if (LogicSchemas.getInstance().schemaExists(schema) && this.isAuthorizedSchema(schema)) {
            this.backendConnection.setCurrentSchema(schema);
            return new UpdateResponse();
        }
        return new ErrorResponse(new UnknownDatabaseException(schema));
    }

    private boolean isAuthorizedSchema(String schema) {
        Collection authorizedSchemas = ((ProxyUser)ShardingProxyContext.getInstance().getAuthentication().getUsers().get(this.backendConnection.getUserName())).getAuthorizedSchemas();
        return authorizedSchemas.isEmpty() || authorizedSchemas.contains(schema);
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public QueryData getQueryData() {
        return null;
    }

    @ConstructorProperties(value={"useStatement", "backendConnection"})
    public UseDatabaseBackendHandler(UseStatement useStatement, BackendConnection backendConnection) {
        this.useStatement = useStatement;
        this.backendConnection = backendConnection;
    }
}

