/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text;

import com.google.common.base.Strings;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.BroadcastBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.ShowDatabasesBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.UnicastBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.UseDatabaseBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.query.QueryBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLBackendHandlerFactory;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.utils.SCTLUtils;
import org.apache.shardingsphere.shardingproxy.backend.text.transaction.SkipBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.transaction.TransactionBackendHandler;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.apache.shardingsphere.sql.parser.core.SQLParseKernel;
import org.apache.shardingsphere.sql.parser.core.rule.registry.ParseRuleRegistry;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.dialect.mysql.ShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dal.dialect.mysql.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.tcl.TCLStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TextProtocolBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(DatabaseType databaseType, String sql, BackendConnection backendConnection) {
        if (Strings.isNullOrEmpty((String)sql)) {
            return new SkipBackendHandler();
        }
        String trimSql = SCTLUtils.trimComment(sql);
        if (trimSql.toUpperCase().startsWith("SCTL:")) {
            return ShardingCTLBackendHandlerFactory.newInstance(trimSql, backendConnection);
        }
        SQLStatement sqlStatement = new SQLParseKernel(ParseRuleRegistry.getInstance(), databaseType.getName(), sql).parse();
        if (sqlStatement instanceof TCLStatement) {
            return TextProtocolBackendHandlerFactory.createTCLBackendHandler(sql, (TCLStatement)sqlStatement, backendConnection);
        }
        if (sqlStatement instanceof DALStatement) {
            return TextProtocolBackendHandlerFactory.createDALBackendHandler((DALStatement)sqlStatement, sql, backendConnection);
        }
        return new QueryBackendHandler(sql, backendConnection);
    }

    private static TextProtocolBackendHandler createTCLBackendHandler(String sql, TCLStatement tclStatement, BackendConnection backendConnection) {
        if (tclStatement instanceof BeginTransactionStatement) {
            return new TransactionBackendHandler(TransactionOperationType.BEGIN, backendConnection);
        }
        if (tclStatement instanceof SetAutoCommitStatement) {
            if (((SetAutoCommitStatement)tclStatement).isAutoCommit()) {
                return backendConnection.getStateHandler().isInTransaction() ? new TransactionBackendHandler(TransactionOperationType.COMMIT, backendConnection) : new SkipBackendHandler();
            }
            return new TransactionBackendHandler(TransactionOperationType.BEGIN, backendConnection);
        }
        if (tclStatement instanceof CommitStatement) {
            return new TransactionBackendHandler(TransactionOperationType.COMMIT, backendConnection);
        }
        if (tclStatement instanceof RollbackStatement) {
            return new TransactionBackendHandler(TransactionOperationType.ROLLBACK, backendConnection);
        }
        return new BroadcastBackendHandler(sql, backendConnection);
    }

    private static TextProtocolBackendHandler createDALBackendHandler(DALStatement dalStatement, String sql, BackendConnection backendConnection) {
        if (dalStatement instanceof UseStatement) {
            return new UseDatabaseBackendHandler((UseStatement)dalStatement, backendConnection);
        }
        if (dalStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesBackendHandler(backendConnection);
        }
        if (dalStatement instanceof SetStatement) {
            return new BroadcastBackendHandler(sql, backendConnection);
        }
        return new UnicastBackendHandler(sql, backendConnection);
    }

    private TextProtocolBackendHandlerFactory() {
    }
}

